/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.classpath.spi;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoadingException;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.impl.StringHelper;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ClassLoaderHelper {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private ClassLoaderHelper() {
    }

    public static <T> T instanceFromName(Class<T> targetSuperType, String classNameToLoad, String componentDescription, ClassResolver classResolver) {
        Class<?> clazzDef = ClassLoaderHelper.classForName(classNameToLoad, componentDescription, classResolver);
        return ClassLoaderHelper.instanceFromClass(targetSuperType, clazzDef, componentDescription);
    }

    public static <T> T instanceFromClass(Class<T> targetSuperType, Class<?> classToLoad, String componentDescription) {
        ClassLoaderHelper.checkClassType(classToLoad, componentDescription);
        Object instance = ClassLoaderHelper.untypedInstanceFromClass(classToLoad, componentDescription);
        return ClassLoaderHelper.verifySuperTypeCompatibility(targetSuperType, instance, classToLoad, componentDescription);
    }

    public static <T> T untypedInstanceFromClass(Class<T> classToLoad, String componentDescription) {
        ClassLoaderHelper.checkClassType(classToLoad, componentDescription);
        Constructor<T> constructor = ClassLoaderHelper.getNoArgConstructor(classToLoad, componentDescription);
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            if (StringHelper.isEmpty((String)componentDescription)) {
                throw log.unableToInstantiateClass(classToLoad, Throwables.getFirstNonNullMessage((Throwable)e), e);
            }
            throw log.unableToInstantiateComponent(componentDescription, classToLoad, Throwables.getFirstNonNullMessage((Throwable)e), e);
        }
    }

    private static <T> T verifySuperTypeCompatibility(Class<T> targetSuperType, Object instance, Class<?> classToLoad, String componentDescription) {
        if (!targetSuperType.isInstance(instance)) {
            if (targetSuperType.isInterface()) {
                throw log.interfaceImplementedExpected(componentDescription, classToLoad, targetSuperType);
            }
            throw log.subtypeExpected(componentDescription, classToLoad, targetSuperType);
        }
        return (T)instance;
    }

    public static <T> T instanceFromClass(Class<T> targetSuperType, Class<?> classToLoad, String componentDescription, Map<String, String> constructorParameter) {
        Object instance;
        ClassLoaderHelper.checkClassType(classToLoad, componentDescription);
        Constructor<?> singleMapConstructor = ClassLoaderHelper.getSingleMapConstructor(classToLoad, componentDescription);
        if (constructorParameter == null) {
            constructorParameter = new HashMap<String, String>(0);
        }
        try {
            instance = singleMapConstructor.newInstance(constructorParameter);
        }
        catch (Exception e) {
            throw log.unableToInstantiateComponent(componentDescription, classToLoad, Throwables.getFirstNonNullMessage((Throwable)e), e);
        }
        return ClassLoaderHelper.verifySuperTypeCompatibility(targetSuperType, instance, classToLoad, componentDescription);
    }

    private static void checkClassType(Class<?> classToLoad, String componentDescription) {
        if (classToLoad.isInterface()) {
            throw log.implementationRequired(componentDescription, classToLoad);
        }
    }

    private static <T> Constructor<T> getNoArgConstructor(Class<T> classToLoad, String componentDescription) {
        try {
            return classToLoad.getConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            throw log.securityManagerLoadingError(componentDescription, classToLoad, e);
        }
        catch (NoSuchMethodException e) {
            throw log.noPublicNoArgConstructor(componentDescription, classToLoad);
        }
    }

    private static Constructor<?> getSingleMapConstructor(Class<?> classToLoad, String componentDescription) {
        try {
            return classToLoad.getConstructor(Map.class);
        }
        catch (SecurityException e) {
            throw log.securityManagerLoadingError(componentDescription, classToLoad, e);
        }
        catch (NoSuchMethodException e) {
            throw log.missingConstructor(componentDescription, classToLoad);
        }
    }

    public static Class<?> classForName(String classNameToLoad, String componentDescription, ClassResolver classResolver) {
        Class clazz;
        try {
            clazz = classResolver.classForName(classNameToLoad);
        }
        catch (ClassLoadingException e) {
            throw log.unableToFindComponentImplementation(componentDescription, classNameToLoad, (Exception)((Object)e));
        }
        return clazz;
    }

    public static <T> Class<? extends T> classForName(Class<T> targetSuperType, String classNameToLoad, String componentDescription, ClassResolver classResolver) {
        Class<?> clazzDef = ClassLoaderHelper.classForName(classNameToLoad, componentDescription, classResolver);
        try {
            return clazzDef.asSubclass(targetSuperType);
        }
        catch (ClassCastException cce) {
            throw log.notAssignableImplementation(componentDescription, classNameToLoad, targetSuperType);
        }
    }

    public static Class<?> classForName(String classNameToLoad, ClassResolver classResolver) {
        return classResolver.classForName(classNameToLoad);
    }
}

