/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaElementImpl;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaRootNodeBuilder;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.mapper.mapping.building.impl.ConfiguredIndexSchemaNestingContext;
import org.hibernate.search.engine.mapper.mapping.building.impl.IndexedEmbeddedBindingContextImpl;
import org.hibernate.search.engine.mapper.mapping.building.impl.NotifyingNestingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexSchemaContributionListener;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedDefinition;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedPathTracker;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEntityBindingMapperContext;

abstract class AbstractIndexBindingContext<B extends IndexSchemaObjectNodeBuilder>
implements IndexBindingContext {
    private final IndexedEntityBindingMapperContext mapperContext;
    private final IndexSchemaRootNodeBuilder indexSchemaRootNodeBuilder;
    final B indexSchemaObjectNodeBuilder;
    final ConfiguredIndexSchemaNestingContext nestingContext;

    AbstractIndexBindingContext(IndexedEntityBindingMapperContext mapperContext, IndexSchemaRootNodeBuilder indexSchemaRootNodeBuilder, B indexSchemaObjectNodeBuilder, ConfiguredIndexSchemaNestingContext nestingContext) {
        this.mapperContext = mapperContext;
        this.indexSchemaRootNodeBuilder = indexSchemaRootNodeBuilder;
        this.indexSchemaObjectNodeBuilder = indexSchemaObjectNodeBuilder;
        this.nestingContext = nestingContext;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexSchemaObjectNodeBuilder=" + this.indexSchemaObjectNodeBuilder + ",nestingContext=" + this.nestingContext + "]";
    }

    @Override
    public IndexFieldTypeFactory createTypeFactory(IndexFieldTypeDefaultsProvider defaultsProvider) {
        return this.indexSchemaRootNodeBuilder.createTypeFactory(defaultsProvider);
    }

    @Override
    public IndexSchemaElement getSchemaElement() {
        return new IndexSchemaElementImpl<B>(this.createTypeFactory(), this.indexSchemaObjectNodeBuilder, this.nestingContext, this.isParentMultivaluedAndWithoutObjectField());
    }

    @Override
    public IndexSchemaElement getSchemaElement(IndexSchemaContributionListener listener) {
        return new IndexSchemaElementImpl<B>(this.createTypeFactory(), this.indexSchemaObjectNodeBuilder, new NotifyingNestingContext(this.nestingContext, listener), this.isParentMultivaluedAndWithoutObjectField());
    }

    @Override
    public Optional<IndexedEmbeddedBindingContext> addIndexedEmbeddedIfIncluded(IndexedEmbeddedDefinition definition, boolean multiValued) {
        IndexedEmbeddedPathTracker pathTracker = this.mapperContext.getOrCreatePathTracker(definition);
        return this.nestingContext.addIndexedEmbeddedIfIncluded(definition, pathTracker, new NestedContextBuilderImpl(this.mapperContext, this.indexSchemaRootNodeBuilder, (IndexSchemaObjectNodeBuilder)this.indexSchemaObjectNodeBuilder, definition, this.isParentMultivaluedAndWithoutObjectField() || multiValued));
    }

    abstract boolean isParentMultivaluedAndWithoutObjectField();

    private static class NestedContextBuilderImpl
    implements ConfiguredIndexSchemaNestingContext.NestedContextBuilder<IndexedEmbeddedBindingContext> {
        private final IndexedEntityBindingMapperContext mapperContext;
        private final IndexSchemaRootNodeBuilder indexSchemaRootNodeBuilder;
        private IndexSchemaObjectNodeBuilder currentNodeBuilder;
        private final IndexedEmbeddedDefinition definition;
        private final List<IndexObjectFieldReference> parentIndexObjectReferences = new ArrayList<IndexObjectFieldReference>();
        private boolean multiValued;

        private NestedContextBuilderImpl(IndexedEntityBindingMapperContext mapperContext, IndexSchemaRootNodeBuilder indexSchemaRootNodeBuilder, IndexSchemaObjectNodeBuilder currentNodeBuilder, IndexedEmbeddedDefinition definition, boolean multiValued) {
            this.mapperContext = mapperContext;
            this.indexSchemaRootNodeBuilder = indexSchemaRootNodeBuilder;
            this.currentNodeBuilder = currentNodeBuilder;
            this.definition = definition;
            this.multiValued = multiValued;
        }

        @Override
        public void appendObject(String objectName) {
            IndexSchemaObjectFieldNodeBuilder nextNodeBuilder = this.currentNodeBuilder.addObjectField(objectName, IndexFieldInclusion.INCLUDED, this.definition.getStorage());
            if (this.multiValued) {
                this.multiValued = false;
                nextNodeBuilder.multiValued();
            }
            this.parentIndexObjectReferences.add(nextNodeBuilder.toReference());
            this.currentNodeBuilder = nextNodeBuilder;
        }

        @Override
        public IndexedEmbeddedBindingContext build(ConfiguredIndexSchemaNestingContext nestingContext) {
            return new IndexedEmbeddedBindingContextImpl(this.mapperContext, this.indexSchemaRootNodeBuilder, this.currentNodeBuilder, this.parentIndexObjectReferences, nestingContext, this.multiValued);
        }
    }
}

