/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.common.spi;

import java.util.Optional;
import org.hibernate.search.util.common.pattern.spi.SimpleGlobPattern;

public class FieldPaths {
    public static final char PATH_SEPARATOR = '.';
    public static final String PATH_SEPARATOR_STRING = String.valueOf('.');

    private FieldPaths() {
    }

    public static String prefix(String prefix, String relativeFieldName) {
        if (prefix == null) {
            return relativeFieldName;
        }
        return prefix + relativeFieldName;
    }

    public static SimpleGlobPattern prefix(String prefix, SimpleGlobPattern relativeFieldPathGlob) {
        if (prefix == null) {
            return relativeFieldPathGlob;
        }
        return relativeFieldPathGlob.prependLiteral(prefix);
    }

    public static String compose(String absolutePath, String relativeFieldName) {
        if (absolutePath == null) {
            return relativeFieldName;
        }
        return absolutePath + '.' + relativeFieldName;
    }

    public static SimpleGlobPattern compose(String absolutePath, SimpleGlobPattern relativeFieldPathGlob) {
        if (absolutePath == null) {
            return relativeFieldPathGlob;
        }
        return relativeFieldPathGlob.prependLiteral(absolutePath + '.');
    }

    public static SimpleGlobPattern absolutize(String absoluteParentPath, String prefix, SimpleGlobPattern relativeFieldPathGlob) {
        return FieldPaths.compose(absoluteParentPath, FieldPaths.prefix(prefix, relativeFieldPathGlob));
    }

    public static String absolutize(String absoluteParentPath, String prefix, String relativeFieldName) {
        return FieldPaths.compose(absoluteParentPath, FieldPaths.prefix(prefix, relativeFieldName));
    }

    public static RelativizedPath relativize(String absolutePath) {
        int lastSeparatorIndex = absolutePath.lastIndexOf(46);
        if (lastSeparatorIndex < 0) {
            return new RelativizedPath(Optional.empty(), absolutePath);
        }
        return new RelativizedPath(Optional.of(absolutePath.substring(0, lastSeparatorIndex)), absolutePath.substring(lastSeparatorIndex + 1));
    }

    public static final class RelativizedPath {
        public final Optional<String> parentPath;
        public final String relativePath;

        private RelativizedPath(Optional<String> parentPath, String relativePath) {
            this.parentPath = parentPath;
            this.relativePath = relativePath;
        }
    }
}

