/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.types.converter.spi;

import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentFieldValueConvertContext;
import org.hibernate.search.util.common.impl.Contracts;

public final class DslConverter<V, F> {
    private final Class<V> valueType;
    private final ToDocumentFieldValueConverter<V, F> delegate;

    public DslConverter(Class<V> valueType, ToDocumentFieldValueConverter<V, F> delegate) {
        Contracts.assertNotNull(valueType, (String)"valueType");
        Contracts.assertNotNull(delegate, (String)"delegate");
        this.valueType = valueType;
        this.delegate = delegate;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[valueType=" + this.valueType.getName() + ",delegate=" + this.delegate + "]";
    }

    public Class<V> valueType() {
        return this.valueType;
    }

    public boolean isValidInputType(Class<?> inputTypeCandidate) {
        return this.valueType.isAssignableFrom(inputTypeCandidate);
    }

    public F convert(V value, ToDocumentFieldValueConvertContext context) {
        return this.delegate.convert(value, context);
    }

    public F convertUnknown(Object value, ToDocumentFieldValueConvertContext context) {
        return this.delegate.convert(this.valueType.cast(value), context);
    }

    public boolean isCompatibleWith(DslConverter<?, ?> other) {
        return this.delegate.isCompatibleWith(other.delegate);
    }
}

