/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.types.converter.spi;

import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.util.common.impl.Contracts;

public final class ProjectionConverter<F, V> {
    private final Class<V> valueType;
    private final FromDocumentFieldValueConverter<F, V> delegate;

    public ProjectionConverter(Class<V> valueType, FromDocumentFieldValueConverter<F, V> delegate) {
        Contracts.assertNotNull(valueType, (String)"valueType");
        Contracts.assertNotNull(delegate, (String)"delegate");
        this.valueType = valueType;
        this.delegate = delegate;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[valueType=" + this.valueType.getName() + ",delegate=" + this.delegate + "]";
    }

    public Class<V> valueType() {
        return this.valueType;
    }

    public boolean isConvertedTypeAssignableTo(Class<?> superTypeCandidate) {
        return superTypeCandidate.isAssignableFrom(this.valueType);
    }

    public V convert(F value, FromDocumentFieldValueConvertContext context) {
        return this.delegate.convert(value, context);
    }

    public boolean isCompatibleWith(ProjectionConverter<?, ?> other) {
        return this.delegate.isCompatibleWith(other.delegate);
    }
}

