/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.cfg.impl.EngineConfigurationUtils;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.common.impl.IndexManagerStartContextImpl;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.reporting.spi.RootFailureCollector;

class IndexManagerNonStartedState {
    private final String backendName;
    private final String indexName;
    private final IndexManagerImplementor indexManager;

    IndexManagerNonStartedState(String backendName, String indexName, IndexManagerImplementor indexManager) {
        this.backendName = backendName;
        this.indexName = indexName;
        this.indexManager = indexManager;
    }

    void closeOnFailure() {
        this.indexManager.stop();
    }

    IndexManagerImplementor start(RootFailureCollector rootFailureCollector, BeanResolver beanResolver, ConfigurationPropertySource rootPropertySource) {
        ContextualFailureCollector indexFailureCollector = rootFailureCollector.withContext(EventContexts.fromIndexName(this.indexName));
        ConfigurationPropertySource backendPropertySource = EngineConfigurationUtils.getBackend(rootPropertySource, this.backendName);
        ConfigurationPropertySource indexPropertySource = EngineConfigurationUtils.getIndex(backendPropertySource, EngineConfigurationUtils.getIndexDefaults(backendPropertySource), this.indexName);
        IndexManagerStartContextImpl startContext = new IndexManagerStartContextImpl(indexFailureCollector, beanResolver, indexPropertySource);
        try {
            this.indexManager.start(startContext);
        }
        catch (RuntimeException e) {
            indexFailureCollector.add(e);
        }
        return this.indexManager;
    }
}

