/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class RangePredicateFieldMoreStepImpl<B>
implements RangePredicateFieldMoreStep<RangePredicateFieldMoreStepImpl<B>, RangePredicateOptionsStep<?>>,
AbstractBooleanMultiFieldPredicateCommonState.FieldSetState<B> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final CommonState<B> commonState;
    private final List<String> absoluteFieldPaths;
    private final List<RangePredicateBuilder<B>> predicateBuilders = new ArrayList<RangePredicateBuilder<B>>();
    private Float fieldSetBoost;

    RangePredicateFieldMoreStepImpl(CommonState<B> commonState, List<String> absoluteFieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.absoluteFieldPaths = absoluteFieldPaths;
        SearchPredicateBuilderFactory predicateFactory = commonState.getFactory();
        for (String absoluteFieldPath : absoluteFieldPaths) {
            this.predicateBuilders.add(predicateFactory.range(absoluteFieldPath));
        }
    }

    @Override
    public RangePredicateFieldMoreStepImpl<B> fields(String ... absoluteFieldPaths) {
        return new RangePredicateFieldMoreStepImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths));
    }

    @Override
    public RangePredicateFieldMoreStepImpl<B> boost(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this;
    }

    @Override
    public RangePredicateOptionsStep<?> range(Range<?> range, ValueConvert convert) {
        return this.commonState.range(range, convert, convert);
    }

    @Override
    public List<String> getAbsoluteFieldPaths() {
        return this.absoluteFieldPaths;
    }

    @Override
    public void contributePredicateBuilders(Consumer<B> collector) {
        for (RangePredicateBuilder<B> predicateBuilder : this.predicateBuilders) {
            this.commonState.applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.toImplementation());
        }
    }

    static class CommonState<B>
    extends AbstractBooleanMultiFieldPredicateCommonState<CommonState<B>, B, RangePredicateFieldMoreStepImpl<B>>
    implements RangePredicateOptionsStep<CommonState<B>> {
        CommonState(SearchPredicateBuilderFactory<?, B> builderFactory) {
            super(builderFactory);
        }

        CommonState<B> range(Range<?> range, ValueConvert lowerBoundConvert, ValueConvert upperBoundConvert) {
            Contracts.assertNotNull(range, (String)"range");
            if (!range.lowerBoundValue().isPresent() && !range.upperBoundValue().isPresent()) {
                throw log.rangePredicateCannotMatchNullValue(this.getEventContext());
            }
            for (RangePredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                for (RangePredicateBuilder predicateBuilder : fieldSetState.predicateBuilders) {
                    predicateBuilder.range(range, lowerBoundConvert, upperBoundConvert);
                }
            }
            return this;
        }

        @Override
        protected B toImplementation() {
            return super.toImplementation();
        }

        @Override
        protected CommonState<B> thisAsS() {
            return this;
        }
    }
}

