/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.common.BooleanOperator;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryFlag;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryStringPredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryStringPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.spi.AbstractPredicateFinalStep;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class SimpleQueryStringPredicateFieldMoreStepImpl<B>
implements SimpleQueryStringPredicateFieldMoreStep<SimpleQueryStringPredicateFieldMoreStepImpl<B>, SimpleQueryStringPredicateOptionsStep<?>> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final CommonState<B> commonState;
    private final List<String> absoluteFieldPaths;
    private final List<SimpleQueryStringPredicateBuilder.FieldState> fieldStates = new ArrayList<SimpleQueryStringPredicateBuilder.FieldState>();

    SimpleQueryStringPredicateFieldMoreStepImpl(CommonState<B> commonState, List<String> absoluteFieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.absoluteFieldPaths = absoluteFieldPaths;
        for (String absoluteFieldPath : absoluteFieldPaths) {
            this.fieldStates.add(commonState.field(absoluteFieldPath));
        }
    }

    @Override
    public SimpleQueryStringPredicateFieldMoreStepImpl<B> fields(String ... absoluteFieldPaths) {
        return new SimpleQueryStringPredicateFieldMoreStepImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths));
    }

    @Override
    public SimpleQueryStringPredicateFieldMoreStepImpl<B> boost(float boost) {
        this.fieldStates.forEach(c -> c.boost(boost));
        return this;
    }

    @Override
    public SimpleQueryStringPredicateOptionsStep<?> matching(String simpleQueryString) {
        return ((CommonState)this.commonState).matching(simpleQueryString);
    }

    static class CommonState<B>
    extends AbstractPredicateFinalStep<B>
    implements SimpleQueryStringPredicateOptionsStep<CommonState<B>> {
        private final SimpleQueryStringPredicateBuilder<B> builder;
        private final List<SimpleQueryStringPredicateFieldMoreStepImpl<B>> fieldSetStates = new ArrayList<SimpleQueryStringPredicateFieldMoreStepImpl<B>>();

        CommonState(SearchPredicateBuilderFactory<?, B> builderFactory) {
            super(builderFactory);
            this.builder = builderFactory.simpleQueryString();
        }

        @Override
        protected B toImplementation() {
            return this.builder.toImplementation();
        }

        void add(SimpleQueryStringPredicateFieldMoreStepImpl<B> fieldSetState) {
            this.fieldSetStates.add(fieldSetState);
        }

        SimpleQueryStringPredicateBuilder.FieldState field(String absoluteFieldPath) {
            return this.builder.field(absoluteFieldPath);
        }

        private SimpleQueryStringPredicateOptionsStep<?> matching(String simpleQueryString) {
            if (simpleQueryString == null) {
                throw log.simpleQueryStringCannotBeNull(this.collectAbsoluteFieldPaths());
            }
            this.builder.simpleQueryString(simpleQueryString);
            return this;
        }

        @Override
        public CommonState<B> constantScore() {
            this.builder.constantScore();
            return this;
        }

        @Override
        public CommonState<B> boost(float boost) {
            this.builder.boost(boost);
            return this;
        }

        @Override
        public CommonState<B> defaultOperator(BooleanOperator operator) {
            this.builder.defaultOperator(operator);
            return this;
        }

        @Override
        public CommonState<B> analyzer(String analyzerName) {
            this.builder.analyzer(analyzerName);
            return this;
        }

        @Override
        public CommonState<B> skipAnalysis() {
            this.builder.skipAnalysis();
            return this;
        }

        private List<String> collectAbsoluteFieldPaths() {
            return this.fieldSetStates.stream().flatMap(f -> ((SimpleQueryStringPredicateFieldMoreStepImpl)f).absoluteFieldPaths.stream()).collect(Collectors.toList());
        }

        @Override
        public CommonState<B> flags(Set<SimpleQueryFlag> flags) {
            this.builder.flags(flags);
            return this;
        }
    }
}

