/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.sort.dsl.impl;

import java.util.function.Function;
import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactoryExtension;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactoryExtensionIfSupportedMoreStep;
import org.hibernate.search.engine.search.sort.dsl.SortFinalStep;
import org.hibernate.search.engine.search.sort.dsl.SortThenStep;
import org.hibernate.search.engine.search.sort.dsl.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.sort.dsl.spi.StaticSortThenStep;

final class SearchSortFactoryExtensionStep<B>
implements SearchSortFactoryExtensionIfSupportedMoreStep {
    private final SearchSortFactory parent;
    private final SearchSortDslContext<?, B, ?> dslContext;
    private final DslExtensionState<SortFinalStep> state = new DslExtensionState();

    SearchSortFactoryExtensionStep(SearchSortFactory parent, SearchSortDslContext<?, B, ?> dslContext) {
        this.parent = parent;
        this.dslContext = dslContext;
    }

    @Override
    public <T> SearchSortFactoryExtensionIfSupportedMoreStep ifSupported(SearchSortFactoryExtension<T> extension, Function<T, ? extends SortFinalStep> sortContributor) {
        this.state.ifSupported(extension, extension.extendOptional(this.parent, this.dslContext), sortContributor);
        return this;
    }

    @Override
    public SortThenStep orElse(Function<SearchSortFactory, ? extends SortFinalStep> sortContributor) {
        SortFinalStep result = this.state.orElse(this.parent, sortContributor);
        return new StaticSortThenStep<B>(this.dslContext, this.dslContext.builderFactory().toImplementation(result.toSort()));
    }

    @Override
    public SortThenStep orElseFail() {
        SortFinalStep result = this.state.orElseFail();
        return new StaticSortThenStep<B>(this.dslContext, this.dslContext.builderFactory().toImplementation(result.toSort()));
    }
}

