/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.query.spi;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.query.SearchResult;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class SimpleSearchResult<H>
implements SearchResult<H> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final long hitCount;
    private final List<H> hits;
    private final Map<AggregationKey<?>, ?> aggregationResults;
    private final Duration took;
    private final boolean timedOut;

    public SimpleSearchResult(long hitCount, List<H> hits, Map<AggregationKey<?>, ?> aggregationResults, Duration took, Boolean timedOut) {
        this.hitCount = hitCount;
        this.hits = hits;
        this.aggregationResults = aggregationResults;
        this.took = took;
        this.timedOut = timedOut != null && timedOut != false;
    }

    @Override
    public long totalHitCount() {
        return this.hitCount;
    }

    @Override
    public List<H> hits() {
        return this.hits;
    }

    @Override
    public <T> T aggregation(AggregationKey<T> key) {
        Object aggregationResult = this.aggregationResults.get(key);
        if (aggregationResult == null && !this.aggregationResults.containsKey(key)) {
            throw log.unknownAggregationKey(key);
        }
        return (T)aggregationResult;
    }

    @Override
    public Duration took() {
        return this.took;
    }

    @Override
    public boolean timedOut() {
        return this.timedOut;
    }

    public String toString() {
        return new StringJoiner(", ", SimpleSearchResult.class.getSimpleName() + "[", "]").add("hitCount=" + this.hitCount).add("hits=" + this.hits).add("aggregationResults=" + this.aggregationResults).add("took=" + this.took).add("timedOut=" + this.timedOut).toString();
    }
}

