/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.impl;

import java.util.Optional;
import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaNestingContext;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.mapper.mapping.building.impl.IndexSchemaFilter;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedDefinition;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedPathTracker;

class ConfiguredIndexSchemaNestingContext
implements IndexSchemaNestingContext {
    private static final ConfiguredIndexSchemaNestingContext ROOT = new ConfiguredIndexSchemaNestingContext(IndexSchemaFilter.root(), "", "");
    private final IndexSchemaFilter filter;
    private final String prefixFromFilter;
    private final String unconsumedPrefix;

    public static ConfiguredIndexSchemaNestingContext root() {
        return ROOT;
    }

    private ConfiguredIndexSchemaNestingContext(IndexSchemaFilter filter, String prefixFromFilter, String unconsumedPrefix) {
        this.filter = filter;
        this.prefixFromFilter = prefixFromFilter;
        this.unconsumedPrefix = unconsumedPrefix;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "filter=" + this.filter + ",prefixFromFilter=" + this.prefixFromFilter + ",unconsumedPrefix=" + this.unconsumedPrefix + "]";
    }

    @Override
    public <T> T nest(String relativeName, IndexSchemaNestingContext.LeafFactory<T> factory) {
        String nameRelativeToFilter = this.prefixFromFilter + relativeName;
        String prefixedRelativeName = this.unconsumedPrefix + relativeName;
        boolean included = this.filter.isPathIncluded(nameRelativeToFilter);
        return factory.create(prefixedRelativeName, included ? IndexFieldInclusion.INCLUDED : IndexFieldInclusion.EXCLUDED);
    }

    @Override
    public <T> T nest(String relativeName, IndexSchemaNestingContext.CompositeFactory<T> factory) {
        String nameRelativeToFilter = this.prefixFromFilter + relativeName;
        String prefixedRelativeName = this.unconsumedPrefix + relativeName;
        boolean included = this.filter.isPathIncluded(nameRelativeToFilter);
        if (included) {
            ConfiguredIndexSchemaNestingContext nestedFilter = new ConfiguredIndexSchemaNestingContext(this.filter, nameRelativeToFilter + ".", "");
            return factory.create(prefixedRelativeName, IndexFieldInclusion.INCLUDED, nestedFilter);
        }
        return factory.create(prefixedRelativeName, IndexFieldInclusion.EXCLUDED, IndexSchemaNestingContext.excludeAll());
    }

    @Override
    public <T> T nestTemplate(IndexSchemaNestingContext.TemplateFactory<T> factory) {
        return factory.create(IndexFieldInclusion.INCLUDED, this.unconsumedPrefix);
    }

    public <T> Optional<T> addIndexedEmbeddedIfIncluded(IndexedEmbeddedDefinition definition, IndexedEmbeddedPathTracker pathTracker, NestedContextBuilder<T> contextBuilder) {
        IndexSchemaFilter composedFilter = this.filter.compose(definition, pathTracker);
        if (!composedFilter.isEveryPathExcluded()) {
            String prefixToParse = this.unconsumedPrefix + definition.relativePrefix();
            int afterPreviousDotIndex = 0;
            int nextDotIndex = prefixToParse.indexOf(46, afterPreviousDotIndex);
            while (nextDotIndex >= 0) {
                String objectName = prefixToParse.substring(afterPreviousDotIndex, nextDotIndex);
                contextBuilder.appendObject(objectName);
                String objectNameRelativeToFilter = prefixToParse.substring(0, nextDotIndex);
                this.filter.isPathIncluded(objectNameRelativeToFilter);
                afterPreviousDotIndex = nextDotIndex + 1;
                nextDotIndex = prefixToParse.indexOf(46, afterPreviousDotIndex);
            }
            String composedUnconsumedPrefix = prefixToParse.substring(afterPreviousDotIndex);
            ConfiguredIndexSchemaNestingContext nestedContext = new ConfiguredIndexSchemaNestingContext(composedFilter, "", composedUnconsumedPrefix);
            return Optional.of(contextBuilder.build(nestedContext));
        }
        return Optional.empty();
    }

    public static interface NestedContextBuilder<T> {
        public void appendObject(String var1);

        public T build(ConfiguredIndexSchemaNestingContext var1);
    }
}

