/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.projection.spi;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class SingleValuedProjectionAccumulator<F, V>
implements ProjectionAccumulator<F, V, F, V> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ProjectionAccumulator.Provider PROVIDER = new ProjectionAccumulator.Provider(){
        private final SingleValuedProjectionAccumulator instance = new SingleValuedProjectionAccumulator();

        public ProjectionAccumulator get() {
            return this.instance;
        }

        @Override
        public boolean isSingleValued() {
            return true;
        }
    };

    public static <V> ProjectionAccumulator.Provider<V, V> provider() {
        return PROVIDER;
    }

    private SingleValuedProjectionAccumulator() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public F createInitial() {
        return null;
    }

    @Override
    public F accumulate(F accumulated, F value) {
        if (accumulated != null) {
            throw log.unexpectedMultiValuedField(accumulated, value);
        }
        return value;
    }

    @Override
    public V finish(F accumulated, ProjectionConverter<? super F, ? extends V> converter, FromDocumentFieldValueConvertContext context) {
        return converter.convert(accumulated, context);
    }
}

