/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.impl;

import java.util.Optional;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;

public class FallbackConfigurationPropertySource
implements ConfigurationPropertySource {
    private final ConfigurationPropertySource main;
    private final ConfigurationPropertySource fallback;

    public FallbackConfigurationPropertySource(ConfigurationPropertySource main, ConfigurationPropertySource fallback) {
        this.main = main;
        this.fallback = fallback;
    }

    @Override
    public Optional<?> get(String key) {
        Optional<?> value = this.main.get(key);
        if (!value.isPresent()) {
            return this.fallback.get(key);
        }
        return value;
    }

    @Override
    public Optional<String> resolve(String key) {
        if (!this.main.get(key).isPresent() && this.fallback.get(key).isPresent()) {
            return this.fallback.resolve(key);
        }
        return this.main.resolve(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("main=").append(this.main).append(", fallback=").append(this.fallback).append("]");
        return sb.toString();
    }
}

