/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.impl;

import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.spi.BeanNotFoundException;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoadingException;
import org.hibernate.search.engine.logging.spi.MappableTypeModelFormatter;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.DurationInSecondsAndFractionsFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter;
import org.hibernate.search.util.common.logging.impl.SimpleNameClassFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.Suppressed;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=0, max=9999)})
public interface Log
extends BasicLogger {
    public static final int ID_OFFSET_LEGACY = 0;
    public static final int ID_OFFSET = 500;

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=230, value="Starting executor '%1$s'")
    public void startingExecutor(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=231, value="Stopping executor '%1$s'")
    public void stoppingExecutor(String var1);

    @Message(id=237, value="Invalid range: at least one bound in range predicates must be non-null.")
    public SearchException rangePredicateCannotMatchNullValue(@Param EventContext var1);

    @Message(id=242, value="Invalid type '%1$s': missing constructor. The type must expose a public, no-arguments constructor.")
    public SearchException noPublicNoArgConstructor(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=501, value="Invalid value for configuration property '%1$s': '%2$s'. %3$s")
    public SearchException unableToConvertConfigurationProperty(String var1, Object var2, String var3, @Cause Exception var4);

    @Message(id=502, value="Invalid value: expected either an instance of '%1$s' or a String that can be parsed into that type. %2$s")
    public SearchException invalidPropertyValue(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, @Cause Exception var3);

    @Message(id=503, value="Invalid Boolean value: expected either a Boolean, the String 'true' or the String 'false'. %1$s")
    public SearchException invalidBooleanPropertyValue(String var1, @Cause Exception var2);

    @Message(id=504, value="Invalid Integer value: expected either a Number or a String that can be parsed into an Integer. %1$s")
    public SearchException invalidIntegerPropertyValue(String var1, @Cause Exception var2);

    @Message(id=505, value="Invalid Long value: expected either a Number or a String that can be parsed into a Long. %1$s")
    public SearchException invalidLongPropertyValue(String var1, @Cause Exception var2);

    @Message(id=506, value="Invalid multi value: expected either a Collection or a String.")
    public SearchException invalidMultiPropertyValue();

    @Message(id=514, value="Invalid index field name '%1$s': field names cannot be null or empty.")
    public SearchException relativeFieldNameCannotBeNullOrEmpty(String var1, @Param EventContext var2);

    @Message(id=515, value="Invalid index field name '%1$s': field names cannot contain a dot ('.'). Remove the dot from your field name, or if you are declaring the field in a bridge and want a tree of fields, declare an object field using the objectField() method.")
    public SearchException relativeFieldNameCannotContainDot(String var1, @Param EventContext var2);

    @Message(id=516, value="Invalid polygon: the first point '%1$s' should be identical to the last point '%2$s' to properly close the polygon.")
    public IllegalArgumentException invalidGeoPolygonFirstPointNotIdenticalToLastPoint(GeoPoint var1, GeoPoint var2);

    @Message(id=519, value="Hibernate Search encountered failures during %1$s. Stopped collecting failures after '%3$s' failures. Failures:\n%2$s")
    public SearchException collectedFailureLimitReached(String var1, String var2, int var3);

    @Message(id=520, value="Hibernate Search encountered failures during %1$s. Failures:\n%2$s")
    public SearchException collectedFailures(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=521, value="Hibernate Search encountered a failure during %1$s; continuing for now to list all problems, but the process will ultimately be aborted.\nContext: %2$s\nFailure:")
    public void newCollectedFailure(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=522, value="Exception while collecting a failure -- this may indicate a bug or a missing test in Hibernate Search. Please report it: https://hibernate.org/community/ Nested exception: %1$s")
    public void exceptionWhileCollectingFailure(String var1, @Cause Throwable var2);

    @Message(id=525, value="Invalid call of ifSupported(...) after orElse(...). Use a separate extension() context, or move the orElse(...) call last.")
    public SearchException cannotCallDslExtensionIfSupportedAfterOrElse();

    @Message(id=526, value="None of the provided extensions can be applied to the current context.  Attempted extensions: %1$s. If you want to ignore this, use .extension().ifSupported(...).orElse(ignored -> { }).")
    public SearchException dslExtensionNoMatch(List<?> var1);

    @Message(id=528, value="Security manager does not allow access to the constructor of type '%1$s': %2$s")
    public SearchException securityManagerLoadingError(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, @Cause Exception var3);

    @Message(id=530, value="Unable to load class '%1$s': %2$s")
    public ClassLoadingException unableToLoadTheClass(String var1, String var2, @Cause Throwable var3);

    @Message(id=533, value="No backend with name '%1$s'. Check that at least one entity is configured to target that backend.")
    public SearchException noBackendRegistered(String var1);

    @Message(id=534, value="No index manager with name '%1$s'. Check that at least one entity is configured to target that index.")
    public SearchException noIndexManagerRegistered(String var1);

    @Message(id=540, value="Unable to instantiate class '%1$s': %2$s")
    public SearchException unableToInstantiateClass(String var1, String var2, @Cause Exception var3);

    @Message(id=542, value="Invalid type '%1$s': this type cannot be assigned to type '%2$s'.")
    public SearchException subtypeExpected(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=543, value="Invalid type '%1$s': this type is an interface. An implementation class is required.")
    public SearchException implementationRequired(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=544, value="Invalid type '%1$s': missing constructor. The type must expose a public constructor with a single parameter of type Map.")
    public SearchException noPublicMapArgConstructor(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=546, value="Infinite @IndexedEmbedded recursion involving path '%1$s' on type '%2$s'.")
    public SearchException indexedEmbeddedCyclicRecursion(String var1, @FormatWith(value=MappableTypeModelFormatter.class) MappableTypeModel var2);

    @Message(id=547, value="Invalid BeanReference value: expected an instance of '%1$s', BeanReference, String or Class. %2$s")
    public SearchException invalidBeanReferencePropertyValue(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, @Cause Exception var3);

    @Message(id=551, value="Invalid use of per-field boost: the predicate score is constant. Cannot assign a different boost to each field when the predicate score is constant.")
    public SearchException perFieldBoostWithConstantScore();

    @Message(id=553, value="Invalid slop: %1$d. The slop must be positive or zero.")
    public SearchException invalidPhrasePredicateSlop(int var1);

    @Message(id=554, value="Invalid maximum edit distance: %1$d. The value must be 0, 1 or 2.")
    public SearchException invalidFuzzyMaximumEditDistance(int var1);

    @Message(id=555, value="Invalid exact prefix length: %1$d. The value must be positive or zero.")
    public SearchException invalidExactPrefixLength(int var1);

    @Message(id=557, value="Invalid value for type '%1$s': '%2$s'. The expected format is '%3$s'.")
    public SearchException unableToParseTemporal(@FormatWith(value=SimpleNameClassFormatter.class) Class<? extends TemporalAccessor> var1, String var2, DateTimeFormatter var3, @Cause Exception var4);

    @Message(id=558, value="Invalid %1$s value: expected either a Number or a String that can be parsed into a %1$s. %2$s")
    public SearchException invalidNumberPropertyValue(@FormatWith(value=SimpleNameClassFormatter.class) Class<? extends Number> var1, String var2, @Cause Exception var3);

    @Message(id=559, value="Invalid value for type '%2$s': '%1$s'. %3$s")
    public SearchException invalidStringForType(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, String var3, @Cause Exception var4);

    @Message(id=560, value="Invalid value for enum '%2$s': '%1$s'.")
    public SearchException invalidStringForEnum(String var1, @FormatWith(value=ClassFormatter.class) Class<? extends Enum> var2, @Cause Exception var3);

    @Message(id=561, value="Multiple hits when a single hit was expected.")
    public SearchException nonSingleHit();

    @Message(id=562, value="Unable to submit work to '%1$s': thread received interrupt signal. The work has been discarded.")
    public SearchException threadInterruptedWhileSubmittingWork(String var1);

    @Message(id=563, value="Unable to submit work to '%1$s': this orchestrator is stopped. The work has been discarded.")
    public SearchException submittedWorkToStoppedOrchestrator(String var1);

    @Message(id=564, value="Invalid geo-point value: '%1$s'. The expected format is '<latitude as double>, <longitude as double>'.")
    public SearchException unableToParseGeoPoint(String var1);

    @Message(id=565, value="Unknown aggregation key '%1$s'. This key was not used when building the search query.")
    public SearchException unknownAggregationKey(AggregationKey<?> var1);

    @Message(id=566, value="Invalid configuration property checking strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidConfigurationPropertyCheckingStrategyName(String var1, List<String> var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=567, value="Configuration property tracking is disabled; unused properties will not be logged.")
    public void configurationPropertyTrackingDisabled();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=568, value="Invalid configuration passed to Hibernate Search: some properties in the given configuration are not used. There might be misspelled property keys in your configuration. Unused properties: %1$s. To disable this warning, set the property '%2$s' to '%3$s'.")
    public void configurationPropertyTrackingUnusedProperties(Set<String> var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=569, value="The background failure handler threw an exception while handling a previous failure. The failure may not have been reported.")
    public void failureInFailureHandler(@Cause Throwable var1);

    @Message(id=570, value="Invalid index field template name '%1$s': field template names cannot be null or empty.")
    public SearchException fieldTemplateNameCannotBeNullOrEmpty(String var1, @Param EventContext var2);

    @Message(id=571, value="Invalid index field template name '%1$s': field template names cannot contain a dot ('.').")
    public SearchException fieldTemplateNameCannotContainDot(String var1, @Param EventContext var2);

    @Message(id=572, value="Inconsistent index data: a supposedly single-valued field returned multiple values. Values: [%1$s, %2$s].")
    public SearchException unexpectedMultiValuedField(Object var1, Object var2);

    @Message(id=573, value="Invalid configuration passed to Hibernate Search: some properties in the given configuration are obsolete.Configuration properties changed between Hibernate Search 5 and Hibernate Search 6 Check out the reference documentation and upgrade your configuration. Obsolete properties: %1$s.")
    public SearchException obsoleteConfigurationPropertiesFromSearch5(Set<String> var1);

    @Message(id=575, value="No default backend. Check that at least one entity is configured to target the default backend.")
    public SearchException noDefaultBackendRegistered();

    @Message(id=576, value="Ambiguous bean reference to type '%1$s': multiple beans are explicitly defined for this type in Hibernate Search's internal registry. Explicitly defined beans: %2$s.")
    public BeanNotFoundException multipleConfiguredBeanReferencesForType(@FormatWith(value=ClassFormatter.class) Class<?> var1, List<? extends BeanReference<?>> var2);

    @Message(id=577, value="No beans defined for type '%1$s' in Hibernate Search's internal registry.")
    public BeanNotFoundException noConfiguredBeanReferenceForType(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=578, value="No beans defined for type '%1$s' and name '%2$s' in Hibernate Search's internal registry.")
    public BeanNotFoundException noConfiguredBeanReferenceForTypeAndName(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2);

    @Message(id=579, value="Unable to resolve bean reference to type '%1$s' and name '%2$s'. %3$s")
    public BeanNotFoundException cannotResolveBeanReference(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, String var3, @Cause RuntimeException var4, @Suppressed Collection<? extends RuntimeException> var5);

    @Message(id=580, value="Unable to resolve bean reference to type '%1$s'. %2$s")
    public BeanNotFoundException cannotResolveBeanReference(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, @Cause RuntimeException var3, @Suppressed Collection<? extends RuntimeException> var4);

    @Message(value="Failed to resolve bean from Hibernate Search's internal registry with exception: %1$s")
    public String failedToResolveBeanUsingInternalRegistry(String var1);

    @Message(value="Failed to resolve bean from bean manager with exception: %1$s")
    public String failedToResolveBeanUsingBeanManager(String var1);

    @Message(value="Failed to resolve bean using reflection with exception: %1$s")
    public String failedToResolveBeanUsingReflection(String var1);

    @Message(id=581, value="Unable to resolve backend type: configuration property '%1$s' is not set, and there isn't any backend in the classpath. Check that you added the desired backend to your project's dependencies.")
    public SearchException noBackendFactoryRegistered(String var1);

    @Message(id=582, value="Ambiguous backend type: configuration property '%1$s' is not set, and multiple backend types are present in the classpath. Set property '%1$s' to one of the following to select the backend type: %2$s")
    public SearchException multipleBackendFactoriesRegistered(String var1, Collection<String> var2);

    @Message(id=583, value="Invalid type for DSL arguments: '%1$s'. Expected '%2$s' or a subtype.")
    public SearchException invalidDslArgumentType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=584, value="Invalid type for returned values: '%1$s'. Expected '%2$s' or a supertype.")
    public SearchException invalidReturnType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=586, value="Operation exceeded the timeout of %1$s.")
    public SearchTimeoutException timedOut(@FormatWith(value=DurationInSecondsAndFractionsFormatter.class) Duration var1, @Cause Exception var2);

    @Message(id=587, value="Unable to provide the exact total hit count: only a lower-bound approximation is available. This is generally the result of setting query options such as a timeout or the total hit count threshold. Either unset these options, or retrieve the lower-bound hit count approximation through '.total().hitCountLowerBound()'.")
    public SearchException notExactTotalHitCount();

    @Message(id=588, value="Multiple entity types mapped to index '%1$s': '%2$s', '%3$s'. Each indexed type must be mapped to its own, dedicated index.")
    public SearchException twoTypesTargetSameIndex(String var1, String var2, String var3);

    @Message(id=589, value="Unable to create bean using reflection: %1$s")
    public BeanNotFoundException unableToCreateBeanUsingReflection(String var1, @Cause Exception var2);

    @Message(id=590, value="No configured bean manager.")
    public BeanNotFoundException noConfiguredBeanManager();

    @Message(id=591, value="Unable to resolve '%2$s' to a class extending '%1$s': %3$s")
    public BeanNotFoundException unableToResolveToClassName(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, String var3, @Cause Exception var4);

    @Message(id=592, value="Invalid bean reference: '%1$s'. The reference is prefixed with '%2$s', which is not a valid bean retrieval prefix. If you want to reference a bean by name, and the name contains a colon, use 'bean:%1$s'. Otherwise, use a valid bean retrieval prefix among the following: %3$s.")
    public BeanNotFoundException invalidBeanRetrieval(String var1, String var2, List<String> var3, @Cause Exception var4);

    @Message(id=593, value="Named predicate name '%1$s' is invalid: field names cannot be null or empty.")
    public SearchException relativeNamedPredicateNameCannotBeNullOrEmpty(String var1, @Param EventContext var2);

    @Message(id=594, value="Named predicate name '%1$s' is invalid: field names cannot contain a dot ('.'). Remove the dot from your named predicate name.")
    public SearchException relativeNamedPredicateNameCannotContainDot(String var1, @Param EventContext var2);

    @Message(id=596, value="Different mappings trying to define two backends with the same name '%1$s' but having different expectations on multi-tenancy.")
    public SearchException differentMultiTenancyNamedBackend(String var1);

    @Message(id=597, value="Different mappings trying to define default backends having different expectations on multi-tenancy.")
    public SearchException differentMultiTenancyDefaultBackend();

    @Message(id=598, value="Invalid type: %1$s is not composite.")
    public SearchException invalidIndexNodeTypeNotComposite(@FormatWith(value=EventContextNoPrefixFormatter.class) EventContext var1);

    @Message(id=599, value="Invalid type: %1$s is not an object field.")
    public SearchException invalidIndexNodeTypeNotObjectField(@FormatWith(value=EventContextNoPrefixFormatter.class) EventContext var1);

    @Message(id=600, value="Invalid type: %1$s is not a value field.")
    public SearchException invalidIndexNodeTypeNotValueField(@FormatWith(value=EventContextNoPrefixFormatter.class) EventContext var1);

    @Message(id=601, value="Inconsistent configuration for %1$s in a search query across multiple indexes: %2$s")
    public SearchException inconsistentConfigurationInContextForSearch(@FormatWith(value=EventContextNoPrefixFormatter.class) EventContext var1, String var2, @Param EventContext var3, @Cause SearchException var4);

    @Message(id=602, value="Inconsistent support for '%1$s': %2$s")
    public SearchException inconsistentSupportForQueryElement(SearchQueryElementTypeKey<?> var1, String var2, @Cause SearchException var3);

    @Message(id=603, value="Attribute '%1$s' differs: '%2$s' vs. '%3$s'.")
    public SearchException differentAttribute(String var1, Object var2, Object var3);

    @Message(id=604, value="Cannot use '%2$s' on %1$s. %3$s")
    public SearchException cannotUseQueryElementForIndexNode(@FormatWith(value=EventContextNoPrefixFormatter.class) EventContext var1, SearchQueryElementTypeKey<?> var2, String var3, @Param EventContext var4);

    @Message(value="Make sure the field is marked as searchable/sortable/projectable/aggregable (whichever is relevant). If it already is, then '%1$s' is not available for fields of this type.")
    public String missingSupportHintForValueField(SearchQueryElementTypeKey<?> var1);

    @Message(value="If you are trying to use the 'nested' predicate, set the field structure to 'NESTED' and reindex all your data. If you are trying to use another predicate, it probably isn't available for this field")
    public String missingSupportHintForCompositNode();

    @Message(id=605, value="Cannot use '%2$s' on %1$s: %3$s")
    public SearchException cannotUseQueryElementForIndexElementBecauseCreationException(@FormatWith(value=EventContextNoPrefixFormatter.class) EventContext var1, SearchQueryElementTypeKey<?> var2, String var3, @Cause SearchException var4, @Param EventContext var5);

    @Message(id=606, value="'%1$s' can be used in some of the targeted indexes, but not all of them. %2$s")
    public SearchException partialSupportForQueryElement(SearchQueryElementTypeKey<?> var1, String var2);

    @Message(value="Make sure the field is marked as searchable/sortable/projectable/aggregable (whichever is relevant) in all indexes, and that the field has the same type in all indexes.")
    public String partialSupportHintForValueField();

    @Message(value="If you are trying to use the 'nested' predicate, set the field structure is to 'NESTED' in all indexes, then reindex all your data.")
    public String partialSupportHintForCompositeNode();

    @Message(id=609, value="This field is a value field in some indexes, but an object field in other indexes.")
    public SearchException conflictingFieldModel();

    @Message(id=610, value="Unknown field '%1$s'.")
    public SearchException unknownFieldForSearch(String var1, @Param EventContext var2);

    @Message(id=611, value="Invalid target fields: fields [%1$s, %3$s] are in different nested documents (%2$s vs. %4$s). All target fields must be in the same document.")
    public SearchException targetFieldsSpanningMultipleNestedPaths(String var1, @FormatWith(value=EventContextNoPrefixFormatter.class) EventContext var2, String var3, @FormatWith(value=EventContextNoPrefixFormatter.class) EventContext var4);
}

