/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.spi;

import java.util.function.Consumer;
import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.ExistsPredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.ExtendedSearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.MatchAllPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.MatchIdPredicateMatchingStep;
import org.hibernate.search.engine.search.predicate.dsl.MatchNonePredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.MatchPredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.NamedPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.NestedPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.NestedPredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.PhrasePredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.RegexpPredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactoryExtension;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactoryExtensionIfSupportedStep;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryStringPredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.SpatialPredicateInitialStep;
import org.hibernate.search.engine.search.predicate.dsl.TermsPredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.WildcardPredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.impl.BooleanPredicateClausesStepImpl;
import org.hibernate.search.engine.search.predicate.dsl.impl.ExistsPredicateFieldStepImpl;
import org.hibernate.search.engine.search.predicate.dsl.impl.MatchAllPredicateOptionsStepImpl;
import org.hibernate.search.engine.search.predicate.dsl.impl.MatchIdPredicateMatchingStepImpl;
import org.hibernate.search.engine.search.predicate.dsl.impl.MatchNonePredicateFinalStepImpl;
import org.hibernate.search.engine.search.predicate.dsl.impl.MatchPredicateFieldStepImpl;
import org.hibernate.search.engine.search.predicate.dsl.impl.NamedPredicateOptionsStepImpl;
import org.hibernate.search.engine.search.predicate.dsl.impl.NestedPredicateClausesStepImpl;
import org.hibernate.search.engine.search.predicate.dsl.impl.NestedPredicateFieldStepImpl;
import org.hibernate.search.engine.search.predicate.dsl.impl.PhrasePredicateFieldStepImpl;
import org.hibernate.search.engine.search.predicate.dsl.impl.RangePredicateFieldStepImpl;
import org.hibernate.search.engine.search.predicate.dsl.impl.RegexpPredicateFieldStepImpl;
import org.hibernate.search.engine.search.predicate.dsl.impl.SearchPredicateFactoryExtensionStep;
import org.hibernate.search.engine.search.predicate.dsl.impl.SimpleQueryStringPredicateFieldStepImpl;
import org.hibernate.search.engine.search.predicate.dsl.impl.SpatialPredicateInitialStepImpl;
import org.hibernate.search.engine.search.predicate.dsl.impl.TermsPredicateFieldStepImpl;
import org.hibernate.search.engine.search.predicate.dsl.impl.WildcardPredicateFieldStepImpl;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateIndexScope;
import org.hibernate.search.util.common.impl.Contracts;

public abstract class AbstractSearchPredicateFactory<S extends ExtendedSearchPredicateFactory<S>, SC extends SearchPredicateIndexScope<?>>
implements ExtendedSearchPredicateFactory<S> {
    protected final SearchPredicateDslContext<SC> dslContext;

    public AbstractSearchPredicateFactory(SearchPredicateDslContext<SC> dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public MatchAllPredicateOptionsStep<?> matchAll() {
        return new MatchAllPredicateOptionsStepImpl(this.dslContext, this);
    }

    @Override
    public MatchNonePredicateFinalStep matchNone() {
        return new MatchNonePredicateFinalStepImpl(this.dslContext);
    }

    @Override
    public MatchIdPredicateMatchingStep<?> id() {
        return new MatchIdPredicateMatchingStepImpl(this.dslContext);
    }

    @Override
    public BooleanPredicateClausesStep<?> bool() {
        return new BooleanPredicateClausesStepImpl(this.dslContext, this);
    }

    @Override
    public PredicateFinalStep bool(Consumer<? super BooleanPredicateClausesStep<?>> clauseContributor) {
        BooleanPredicateClausesStep<?> next = this.bool();
        clauseContributor.accept(next);
        return next;
    }

    @Override
    public MatchPredicateFieldStep<?> match() {
        return new MatchPredicateFieldStepImpl(this.dslContext);
    }

    @Override
    public RangePredicateFieldStep<?> range() {
        return new RangePredicateFieldStepImpl(this.dslContext);
    }

    @Override
    public PhrasePredicateFieldStep<?> phrase() {
        return new PhrasePredicateFieldStepImpl(this.dslContext);
    }

    @Override
    public WildcardPredicateFieldStep<?> wildcard() {
        return new WildcardPredicateFieldStepImpl(this.dslContext);
    }

    @Override
    public RegexpPredicateFieldStep<?> regexp() {
        return new RegexpPredicateFieldStepImpl(this.dslContext);
    }

    @Override
    public TermsPredicateFieldStep<?> terms() {
        return new TermsPredicateFieldStepImpl(this.dslContext);
    }

    @Override
    @Deprecated
    public NestedPredicateFieldStep<?> nested() {
        return new NestedPredicateFieldStepImpl(this.dslContext, this);
    }

    @Override
    public NestedPredicateClausesStep<?> nested(String objectFieldPath) {
        return new NestedPredicateClausesStepImpl(this.dslContext, objectFieldPath, this);
    }

    @Override
    public SimpleQueryStringPredicateFieldStep<?> simpleQueryString() {
        return new SimpleQueryStringPredicateFieldStepImpl(this.dslContext);
    }

    @Override
    public ExistsPredicateFieldStep<?> exists() {
        return new ExistsPredicateFieldStepImpl(this.dslContext);
    }

    @Override
    public SpatialPredicateInitialStep spatial() {
        return new SpatialPredicateInitialStepImpl(this.dslContext);
    }

    @Override
    public NamedPredicateOptionsStep named(String path) {
        String predicateName;
        String fieldPath;
        Contracts.assertNotNull((Object)path, (String)"path");
        int dotIndex = path.lastIndexOf(46);
        if (dotIndex >= 0) {
            fieldPath = path.substring(0, dotIndex);
            predicateName = path.substring(dotIndex + 1);
        } else {
            fieldPath = null;
            predicateName = path;
        }
        return new NamedPredicateOptionsStepImpl(this, this.dslContext, fieldPath, predicateName);
    }

    @Override
    public <T> T extension(SearchPredicateFactoryExtension<T> extension) {
        return DslExtensionState.returnIfSupported(extension, extension.extendOptional(this));
    }

    @Override
    public SearchPredicateFactoryExtensionIfSupportedStep extension() {
        return new SearchPredicateFactoryExtensionStep(this);
    }

    @Override
    public final String toAbsolutePath(String relativeFieldPath) {
        return this.dslContext.scope().toAbsolutePath(relativeFieldPath);
    }
}

