/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.spi;

import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertyChecker;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.environment.bean.impl.BeanResolverImpl;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.engine.environment.classpath.spi.AggregatedClassLoader;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.DefaultClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.DefaultResourceResolver;
import org.hibernate.search.engine.environment.classpath.spi.DefaultServiceResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;
import org.hibernate.search.engine.environment.classpath.spi.ServiceResolver;

public final class SearchIntegrationEnvironment
implements AutoCloseable {
    public static final String CONFIGURATION_PROPERTIES_MASK = "hibernate.search";
    private final ConfigurationPropertySource propertySource;
    private final ConfigurationPropertyChecker propertyChecker;
    private final ClassResolver classResolver;
    private final ResourceResolver resourceResolver;
    private final ServiceResolver serviceResolver;
    private final BeanResolver beanResolver;
    private final BeanProvider beanProvider;

    private SearchIntegrationEnvironment(Builder builder) {
        this.propertySource = builder.propertySource.withMask(CONFIGURATION_PROPERTIES_MASK);
        this.propertyChecker = builder.propertyChecker;
        AggregatedClassLoader aggregatedClassLoader = null;
        if (builder.classResolver != null) {
            this.classResolver = builder.classResolver;
        } else {
            aggregatedClassLoader = AggregatedClassLoader.createDefault();
            this.classResolver = DefaultClassResolver.create(aggregatedClassLoader);
        }
        if (builder.resourceResolver != null) {
            this.resourceResolver = builder.resourceResolver;
        } else {
            if (aggregatedClassLoader == null) {
                aggregatedClassLoader = AggregatedClassLoader.createDefault();
            }
            this.resourceResolver = DefaultResourceResolver.create(aggregatedClassLoader);
        }
        if (builder.serviceResolver != null) {
            this.serviceResolver = builder.serviceResolver;
        } else {
            if (aggregatedClassLoader == null) {
                aggregatedClassLoader = AggregatedClassLoader.createDefault();
            }
            this.serviceResolver = DefaultServiceResolver.create(aggregatedClassLoader);
        }
        this.beanProvider = builder.beanProvider;
        this.beanResolver = BeanResolverImpl.create(this.classResolver, this.serviceResolver, this.beanProvider, this.propertySource);
    }

    private SearchIntegrationEnvironment(SearchIntegrationEnvironment source, ConfigurationPropertySource propertySource, ConfigurationPropertyChecker checker) {
        this.propertySource = propertySource.withMask(CONFIGURATION_PROPERTIES_MASK);
        this.propertyChecker = checker;
        this.classResolver = source.classResolver;
        this.resourceResolver = source.resourceResolver;
        this.serviceResolver = source.serviceResolver;
        this.beanProvider = source.beanProvider;
        this.beanResolver = source.beanResolver;
    }

    @Override
    public void close() {
        if (this.beanProvider != null) {
            this.beanProvider.close();
        }
    }

    public ConfigurationPropertySource propertySource() {
        return this.propertySource;
    }

    public ConfigurationPropertyChecker propertyChecker() {
        return this.propertyChecker;
    }

    public ClassResolver classResolver() {
        return this.classResolver;
    }

    public ResourceResolver resourceResolver() {
        return this.resourceResolver;
    }

    public ServiceResolver serviceResolver() {
        return this.serviceResolver;
    }

    public BeanResolver beanResolver() {
        return this.beanResolver;
    }

    public BeanProvider beanProvider() {
        return this.beanProvider;
    }

    public SearchIntegrationEnvironment override(ConfigurationPropertySource propertySource, ConfigurationPropertyChecker propertyChecker) {
        return new SearchIntegrationEnvironment(this, propertySource, propertyChecker);
    }

    public static Builder builder(ConfigurationPropertySource propertySource, ConfigurationPropertyChecker propertyChecker) {
        return new Builder(propertySource, propertyChecker);
    }

    public static final class Builder {
        private final ConfigurationPropertySource propertySource;
        private final ConfigurationPropertyChecker propertyChecker;
        private ClassResolver classResolver;
        private ResourceResolver resourceResolver;
        private ServiceResolver serviceResolver;
        private BeanProvider beanProvider;

        private Builder(ConfigurationPropertySource propertySource, ConfigurationPropertyChecker propertyChecker) {
            this.propertySource = propertySource;
            this.propertyChecker = propertyChecker;
        }

        public Builder classResolver(ClassResolver classResolver) {
            this.classResolver = classResolver;
            return this;
        }

        public Builder resourceResolver(ResourceResolver resourceResolver) {
            this.resourceResolver = resourceResolver;
            return this;
        }

        public Builder serviceResolver(ServiceResolver serviceResolver) {
            this.serviceResolver = serviceResolver;
            return this;
        }

        public Builder beanProvider(BeanProvider beanProvider) {
            this.beanProvider = beanProvider;
            return this;
        }

        public SearchIntegrationEnvironment build() {
            return new SearchIntegrationEnvironment(this);
        }
    }
}

