/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.tree.spi;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.engine.common.tree.TreeFilterDefinition;

public final class TreeFilterPathTracker {
    private final TreeFilterDefinition definition;
    private final Map<String, Boolean> encounteredFieldPaths = new LinkedHashMap<String, Boolean>();

    public TreeFilterPathTracker(TreeFilterDefinition definition) {
        this.definition = definition;
    }

    public Set<String> uselessIncludePaths() {
        LinkedHashSet<String> uselessIncludePaths = new LinkedHashSet<String>();
        for (String path : this.definition.includePaths()) {
            Boolean included = this.encounteredFieldPaths.get(path);
            if (included != null && included.booleanValue()) continue;
            uselessIncludePaths.add(path);
        }
        return uselessIncludePaths;
    }

    public Set<String> uselessExcludePaths() {
        LinkedHashSet<String> uselessExcludePaths = new LinkedHashSet<String>();
        for (String path : this.definition.excludePaths()) {
            if (this.encounteredFieldPaths.containsKey(path)) continue;
            uselessExcludePaths.add(path);
        }
        return uselessExcludePaths;
    }

    public Set<String> encounteredFieldPaths() {
        return this.encounteredFieldPaths.keySet();
    }

    public void markAsEncountered(String relativePath, boolean includedByThis) {
        this.encounteredFieldPaths.merge(relativePath, includedByThis, (included1, included2) -> included1 != false || included2 != false);
    }
}

