/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.RegexpPredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.RegexpPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.RegexpQueryFlag;
import org.hibernate.search.engine.search.predicate.dsl.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.predicate.spi.RegexpPredicateBuilder;
import org.hibernate.search.util.common.impl.Contracts;

class RegexpPredicateFieldMoreStepImpl
implements RegexpPredicateFieldMoreStep<RegexpPredicateFieldMoreStepImpl, RegexpPredicateOptionsStep<?>>,
AbstractBooleanMultiFieldPredicateCommonState.FieldSetState {
    private final CommonState commonState;
    private final List<RegexpPredicateBuilder> predicateBuilders = new ArrayList<RegexpPredicateBuilder>();
    private Float fieldSetBoost;

    RegexpPredicateFieldMoreStepImpl(CommonState commonState, List<String> fieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        SearchIndexScope<?> scope = commonState.scope();
        for (String fieldPath : fieldPaths) {
            this.predicateBuilders.add(scope.fieldQueryElement(fieldPath, PredicateTypeKeys.REGEXP));
        }
    }

    @Override
    public RegexpPredicateFieldMoreStepImpl fields(String ... fieldPaths) {
        return new RegexpPredicateFieldMoreStepImpl(this.commonState, Arrays.asList(fieldPaths));
    }

    @Override
    public RegexpPredicateFieldMoreStepImpl boost(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this;
    }

    @Override
    public RegexpPredicateOptionsStep<?> matching(String regexpPattern) {
        return this.commonState.matching(regexpPattern);
    }

    @Override
    public void contributePredicates(Consumer<SearchPredicate> collector) {
        for (RegexpPredicateBuilder predicateBuilder : this.predicateBuilders) {
            this.commonState.applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.build());
        }
    }

    static class CommonState
    extends AbstractBooleanMultiFieldPredicateCommonState<CommonState, RegexpPredicateFieldMoreStepImpl>
    implements RegexpPredicateOptionsStep<CommonState> {
        CommonState(SearchPredicateDslContext<?> dslContext) {
            super(dslContext);
        }

        private RegexpPredicateOptionsStep<?> matching(String regexpPattern) {
            Contracts.assertNotNull((Object)regexpPattern, (String)"regexpPattern");
            for (RegexpPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                for (RegexpPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders) {
                    predicateBuilder.pattern(regexpPattern);
                }
            }
            return this;
        }

        @Override
        protected CommonState thisAsS() {
            return this;
        }

        @Override
        public CommonState flags(Set<RegexpQueryFlag> flags) {
            for (RegexpPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                for (RegexpPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders) {
                    predicateBuilder.flags(flags);
                }
            }
            return this;
        }
    }
}

