/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.types.converter.spi;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.function.Function;
import org.hibernate.search.engine.backend.types.converter.ToDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentValueConvertContext;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.annotation.Incubating;

@Incubating
public final class DefaultParseConverters {
    public static final ToDocumentValueConverter<String, BigDecimal> BIG_DECIMAL = new Converter<BigDecimal>(ParseUtils::parseBigDecimal);
    public static final ToDocumentValueConverter<String, BigInteger> BIG_INTEGER = new Converter<BigInteger>(ParseUtils::parseBigInteger);
    public static final ToDocumentValueConverter<String, Boolean> BOOLEAN = new Converter<Boolean>(ParseUtils::parseBoolean);
    public static final ToDocumentValueConverter<String, Byte> BYTE = new Converter<Byte>(ParseUtils::parseByte);
    public static final ToDocumentValueConverter<String, Double> DOUBLE = new Converter<Double>(ParseUtils::parseDouble);
    public static final ToDocumentValueConverter<String, Float> FLOAT = new Converter<Float>(ParseUtils::parseFloat);
    public static final ToDocumentValueConverter<String, GeoPoint> GEO_POINT = new Converter<GeoPoint>(ParseUtils::parseGeoPoint);
    public static final ToDocumentValueConverter<String, Instant> INSTANT = new Converter<Instant>(ParseUtils::parseInstant);
    public static final ToDocumentValueConverter<String, Integer> INTEGER = new Converter<Integer>(ParseUtils::parseInteger);
    public static final ToDocumentValueConverter<String, LocalDate> LOCAL_DATE = new Converter<LocalDate>(ParseUtils::parseLocalDate);
    public static final ToDocumentValueConverter<String, LocalDateTime> LOCAL_DATE_TIME = new Converter<LocalDateTime>(ParseUtils::parseLocalDateTime);
    public static final ToDocumentValueConverter<String, LocalTime> LOCAL_TIME = new Converter<LocalTime>(ParseUtils::parseLocalTime);
    public static final ToDocumentValueConverter<String, Long> LONG = new Converter<Long>(ParseUtils::parseLong);
    public static final ToDocumentValueConverter<String, MonthDay> MONTH_DAY = new Converter<MonthDay>(ParseUtils::parseMonthDay);
    public static final ToDocumentValueConverter<String, OffsetDateTime> OFFSET_DATE_TIME = new Converter<OffsetDateTime>(ParseUtils::parseOffsetDateTime);
    public static final ToDocumentValueConverter<String, OffsetTime> OFFSET_TIME = new Converter<OffsetTime>(ParseUtils::parseOffsetTime);
    public static final ToDocumentValueConverter<String, Short> SHORT = new Converter<Short>(ParseUtils::parseShort);
    public static final ToDocumentValueConverter<String, String> STRING = new Converter<String>(ParseUtils::parseString);
    public static final ToDocumentValueConverter<String, Year> YEAR = new Converter<Year>(ParseUtils::parseYear);
    public static final ToDocumentValueConverter<String, YearMonth> YEAR_MONTH = new Converter<YearMonth>(ParseUtils::parseYearMonth);
    public static final ToDocumentValueConverter<String, ZonedDateTime> ZONED_DATE_TIME = new Converter<ZonedDateTime>(ParseUtils::parseZonedDateTime);

    private DefaultParseConverters() {
    }

    private static class Converter<F>
    implements ToDocumentValueConverter<String, F> {
        private final Function<String, F> delegate;

        private Converter(Function<String, F> delegate) {
            this.delegate = delegate;
        }

        @Override
        public F toDocumentValue(String value, ToDocumentValueConvertContext context) {
            return value == null ? null : (F)this.delegate.apply(value);
        }

        @Override
        public boolean isCompatibleWith(ToDocumentValueConverter<?, ?> other) {
            return other == this;
        }
    }
}

