/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.scope.spi;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.search.engine.backend.document.model.spi.AbstractIndexModel;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.metamodel.IndexCompositeElementDescriptor;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentValueConvertContext;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.spi.MultiIndexSearchIndexIdentifierContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexCompositeNodeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexIdentifierContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexNodeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.engine.search.projection.definition.spi.ProjectionRegistry;
import org.hibernate.search.engine.search.projection.spi.ProjectionMappedTypeContext;
import org.hibernate.search.engine.search.query.spi.SearchQueryIndexScope;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public abstract class AbstractSearchIndexScope<S extends SearchQueryIndexScope<?>, M extends AbstractIndexModel<?, ? extends C, ? extends N>, N extends SearchIndexNodeContext<? super S>, C extends SearchIndexCompositeNodeContext<? super S>>
implements SearchIndexScope<S>,
SearchQueryIndexScope<S> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final BackendMappingContext mappingContext;
    private final Set<String> hibernateSearchIndexNames;
    private final Set<? extends M> indexModels;
    private final List<ProjectionMappedTypeContext> mappedTypeContexts;
    private final C overriddenRoot;

    public AbstractSearchIndexScope(BackendMappingContext mappingContext, Set<? extends M> indexModels) {
        this.mappingContext = mappingContext;
        this.hibernateSearchIndexNames = new TreeSet<String>();
        this.mappedTypeContexts = new ArrayList<ProjectionMappedTypeContext>();
        for (AbstractIndexModel model : indexModels) {
            this.hibernateSearchIndexNames.add(model.hibernateSearchName());
            this.mappedTypeContexts.add(mappingContext.mappedTypeContext(model.mappedTypeName()));
        }
        this.indexModels = indexModels;
        this.overriddenRoot = null;
    }

    protected AbstractSearchIndexScope(AbstractSearchIndexScope<S, M, N, C> parentScope, C overriddenRoot) {
        this.mappingContext = parentScope.mappingContext;
        this.hibernateSearchIndexNames = parentScope.hibernateSearchIndexNames;
        this.indexModels = parentScope.indexModels;
        this.mappedTypeContexts = parentScope.mappedTypeContexts;
        this.overriddenRoot = overriddenRoot;
    }

    @Override
    public BackendMappingContext mappingContext() {
        return this.mappingContext;
    }

    public EventContext eventContext() {
        return EventContexts.fromIndexNames(this.hibernateSearchIndexNames);
    }

    protected final EventContext indexesAndRootEventContext() {
        if (this.overriddenRoot == null) {
            return this.eventContext();
        }
        return this.eventContext().append(this.overriddenRoot.relativeEventContext());
    }

    protected abstract S self();

    @Override
    public final ToDocumentValueConvertContext toDocumentValueConvertContext() {
        return this.mappingContext.toDocumentValueConvertContext();
    }

    @Override
    public final Set<String> hibernateSearchIndexNames() {
        return this.hibernateSearchIndexNames;
    }

    @Override
    public String toAbsolutePath(String relativeFieldPath) {
        Contracts.assertNotNull((Object)relativeFieldPath, (String)"relativeFieldPath");
        return this.overriddenRoot == null ? relativeFieldPath : this.overriddenRoot.absolutePath(relativeFieldPath);
    }

    @Override
    public SearchIndexIdentifierContext identifier() {
        if (this.indexModels.size() == 1) {
            return ((AbstractIndexModel)this.indexModels.iterator().next()).identifier();
        }
        ArrayList<SearchIndexIdentifierContext> identifierForEachIndex = new ArrayList<SearchIndexIdentifierContext>();
        for (AbstractIndexModel model : this.indexModels) {
            identifierForEachIndex.add(model.identifier());
        }
        return new MultiIndexSearchIndexIdentifierContext(this, identifierForEachIndex);
    }

    protected C root() {
        if (this.overriddenRoot != null) {
            return this.overriddenRoot;
        }
        if (this.indexModels.size() == 1) {
            return (C)((AbstractIndexModel)this.indexModels.iterator().next()).root();
        }
        ArrayList<IndexCompositeElementDescriptor> rootForEachIndex = new ArrayList<IndexCompositeElementDescriptor>();
        for (AbstractIndexModel model : this.indexModels) {
            rootForEachIndex.add(model.root());
        }
        return (C)this.createMultiIndexSearchRootContext(rootForEachIndex);
    }

    protected N field(String fieldPath) {
        if (this.overriddenRoot != null) {
            return this.fieldInternal(this.overriddenRoot.absolutePath(fieldPath));
        }
        return this.fieldInternal(fieldPath);
    }

    private N fieldInternal(String absoluteFieldPath) {
        Object resultOrNull = this.indexModels.size() == 1 ? ((AbstractIndexModel)this.indexModels.iterator().next()).fieldOrNull(absoluteFieldPath) : this.createMultiIndexFieldContext(absoluteFieldPath);
        if (resultOrNull == null) {
            throw log.unknownFieldForSearch(absoluteFieldPath, this.indexesAndRootEventContext());
        }
        return resultOrNull;
    }

    public final N child(SearchIndexCompositeNodeContext<?> parent, String name) {
        return this.fieldInternal(parent.absolutePath(name));
    }

    private N createMultiIndexFieldContext(String absoluteFieldPath) {
        ArrayList fieldForEachIndex = new ArrayList();
        AbstractIndexModel modelOfFirstField = null;
        SearchIndexNodeContext<Object> firstField = null;
        for (AbstractIndexModel model : this.indexModels) {
            Object fieldForCurrentIndex = model.fieldOrNull(absoluteFieldPath);
            if (fieldForCurrentIndex == null) continue;
            if (firstField == null) {
                modelOfFirstField = model;
                firstField = fieldForCurrentIndex;
            } else if (firstField.isComposite() != fieldForCurrentIndex.isComposite()) {
                SearchException cause = log.conflictingFieldModel();
                throw log.inconsistentConfigurationInContextForSearch(EventContexts.fromIndexFieldAbsolutePath(absoluteFieldPath), cause.getMessage(), EventContexts.fromIndexNames(modelOfFirstField.hibernateSearchName(), model.hibernateSearchName()), cause);
            }
            fieldForEachIndex.add(fieldForCurrentIndex);
        }
        if (firstField == null) {
            return null;
        }
        if (firstField.isComposite()) {
            return (N)this.createMultiIndexSearchObjectFieldContext(absoluteFieldPath, fieldForEachIndex);
        }
        return (N)this.createMultiIndexSearchValueFieldContext(absoluteFieldPath, fieldForEachIndex);
    }

    @Override
    public final <T> T rootQueryElement(SearchQueryElementTypeKey<T> key) {
        return this.root().queryElement(key, this.self());
    }

    @Override
    public final <T> T fieldQueryElement(String fieldPath, SearchQueryElementTypeKey<T> key) {
        return this.field(fieldPath).queryElement(key, this.self());
    }

    @Override
    public ProjectionRegistry projectionRegistry() {
        return this.mappingContext.projectionRegistry();
    }

    @Override
    public List<? extends ProjectionMappedTypeContext> mappedTypeContexts() {
        return this.mappedTypeContexts;
    }

    protected abstract C createMultiIndexSearchRootContext(List<C> var1);

    protected abstract N createMultiIndexSearchValueFieldContext(String var1, List<N> var2);

    protected abstract N createMultiIndexSearchObjectFieldContext(String var1, List<N> var2);
}

