/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.impl;

import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.search.engine.logging.impl.FormattingLog;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.SimpleNameClassFormatter;
import org.jboss.logging.Logger;

public class FormattingLog_$logger
implements FormattingLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = FormattingLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public FormattingLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String invalidPropertyValue$str() {
        return "HSEARCH000502: Invalid value: expected either an instance of '%1$s' or a String that can be parsed into that type. %2$s";
    }

    @Override
    public final SearchException invalidPropertyValue(Class<?> expectedType, String errorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidPropertyValue$str(), new ClassFormatter(expectedType), errorMessage), (Throwable)cause);
        FormattingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String invalidBooleanPropertyValue$str() {
        return "HSEARCH000503: Invalid Boolean value: expected either a Boolean, the String 'true' or the String 'false'. %1$s";
    }

    @Override
    public final SearchException invalidBooleanPropertyValue(String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidBooleanPropertyValue$str(), nestedErrorMessage), (Throwable)cause);
        FormattingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIntegerPropertyValue$str() {
        return "HSEARCH000504: Invalid Integer value: expected either a Number or a String that can be parsed into an Integer. %1$s";
    }

    @Override
    public final SearchException invalidIntegerPropertyValue(String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIntegerPropertyValue$str(), nestedErrorMessage), (Throwable)cause);
        FormattingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidLongPropertyValue$str() {
        return "HSEARCH000505: Invalid Long value: expected either a Number or a String that can be parsed into a Long. %1$s";
    }

    @Override
    public final SearchException invalidLongPropertyValue(String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidLongPropertyValue$str(), nestedErrorMessage), (Throwable)cause);
        FormattingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMultiPropertyValue$str() {
        return "HSEARCH000506: Invalid multi value: expected either a single value of the correct type, a Collection, or a String, and interpreting as a single value failed with the following exception. %1$s";
    }

    @Override
    public final SearchException invalidMultiPropertyValue(String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidMultiPropertyValue$str(), nestedErrorMessage), (Throwable)cause);
        FormattingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidGeoPolygonFirstPointNotIdenticalToLastPoint$str() {
        return "HSEARCH000516: Invalid polygon: the first point '%1$s' should be identical to the last point '%2$s' to properly close the polygon.";
    }

    @Override
    public final IllegalArgumentException invalidGeoPolygonFirstPointNotIdenticalToLastPoint(GeoPoint firstPoint, GeoPoint lastPoint) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidGeoPolygonFirstPointNotIdenticalToLastPoint$str(), firstPoint, lastPoint));
        FormattingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidBeanReferencePropertyValue$str() {
        return "HSEARCH000547: Invalid BeanReference value: expected an instance of '%1$s', BeanReference, String or Class. %2$s";
    }

    @Override
    public final SearchException invalidBeanReferencePropertyValue(Class<?> expectedType, String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidBeanReferencePropertyValue$str(), new ClassFormatter(expectedType), nestedErrorMessage), (Throwable)cause);
        FormattingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToParseTemporal$str() {
        return "HSEARCH000557: Invalid value for type '%1$s': '%2$s'. The expected format is '%3$s'.";
    }

    @Override
    public final SearchException unableToParseTemporal(Class<? extends TemporalAccessor> type, String value, DateTimeFormatter formatter, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToParseTemporal$str(), new SimpleNameClassFormatter(type), value, formatter), (Throwable)cause);
        FormattingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidNumberPropertyValue$str() {
        return "HSEARCH000558: Invalid %1$s value: expected either a Number or a String that can be parsed into a %1$s. %2$s";
    }

    @Override
    public final SearchException invalidNumberPropertyValue(Class<? extends Number> type, String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidNumberPropertyValue$str(), new SimpleNameClassFormatter(type), nestedErrorMessage), (Throwable)cause);
        FormattingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidStringForType$str() {
        return "HSEARCH000559: Invalid string for type '%2$s': '%1$s'. %3$s";
    }

    @Override
    public final SearchException invalidStringForType(String value, Class<?> type, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidStringForType$str(), value, new ClassFormatter(type), causeMessage), (Throwable)cause);
        FormattingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidStringForEnum$str() {
        return "HSEARCH000560: Invalid value for enum '%2$s': '%1$s'.";
    }

    @Override
    public final SearchException invalidStringForEnum(String value, Class<? extends Enum<?>> enumType, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidStringForEnum$str(), value, new ClassFormatter(enumType)), (Throwable)cause);
        FormattingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToParseGeoPoint$str() {
        return "HSEARCH000564: Invalid geo-point value: '%1$s'. The expected format is '<latitude as double>, <longitude as double>'.";
    }

    @Override
    public final SearchException unableToParseGeoPoint(String value) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToParseGeoPoint$str(), value));
        FormattingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

