/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.spatial;

import java.util.Objects;
import org.hibernate.search.engine.spatial.GeoBoundingBox;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.impl.Contracts;

final class ImmutableGeoBoundingBox
implements GeoBoundingBox {
    private final GeoPoint topLeft;
    private final GeoPoint bottomRight;

    ImmutableGeoBoundingBox(GeoPoint topLeft, GeoPoint bottomRight) {
        Contracts.assertNotNull((Object)topLeft, (String)"topLeft");
        Contracts.assertNotNull((Object)bottomRight, (String)"bottomRight");
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
    }

    @Override
    public GeoPoint topLeft() {
        return this.topLeft;
    }

    @Override
    public GeoPoint bottomRight() {
        return this.bottomRight;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableGeoBoundingBox that = (ImmutableGeoBoundingBox)obj;
        return Objects.equals(that.topLeft, this.topLeft) && Objects.equals(that.bottomRight, this.bottomRight);
    }

    public int hashCode() {
        return Objects.hash(this.topLeft, this.bottomRight);
    }

    public String toString() {
        return "ImmutableGeoBoundingBox[topLeft=" + String.valueOf(this.topLeft) + ", bottomRight=" + String.valueOf(this.bottomRight) + "]";
    }
}

