package org.hibernate.search.engine.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import java.util.Set;
import org.hibernate.search.util.common.SearchException;
import java.util.ServiceConfigurationError;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Class;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class ConfigurationLog_$logger implements ConfigurationLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConfigurationLog_$logger.class.getName();
    public ConfigurationLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String unableToConvertConfigurationProperty$str() {
        return "HSEARCH000501: Invalid value for configuration property '%1$s': '%2$s'. %3$s";
    }
    @Override
    public final SearchException unableToConvertConfigurationProperty(final String key, final Object rawValue, final String errorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToConvertConfigurationProperty$str(), key, rawValue, errorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unknownNameForBackend$str() {
        return "HSEARCH000533: No backend with name '%1$s'. Check that at least one entity is configured to target that backend. The following backends can be retrieved by name: %2$s. %3$s";
    }
    @Override
    public final SearchException unknownNameForBackend(final String backendName, final Collection<String> validBackendNames, final String defaultBackendMessage) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownNameForBackend$str(), backendName, validBackendNames, defaultBackendMessage));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownNameForIndexManager$str() {
        return "HSEARCH000534: No index manager with name '%1$s'. Check that at least one entity is configured to target that index. The following indexes can be retrieved by name: %2$s.";
    }
    @Override
    public final SearchException unknownNameForIndexManager(final String indexManagerName, final Collection<String> validIndexNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownNameForIndexManager$str(), indexManagerName, validIndexNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidConfigurationPropertyCheckingStrategyName$str() {
        return "HSEARCH000566: Invalid configuration property checking strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidConfigurationPropertyCheckingStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidConfigurationPropertyCheckingStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void configurationPropertyTrackingDisabled() {
        log.logf(FQCN, INFO, null, configurationPropertyTrackingDisabled$str());
    }
    protected String configurationPropertyTrackingDisabled$str() {
        return "HSEARCH000567: Configuration property tracking is disabled; unused properties will not be logged.";
    }
    @Override
    public final void configurationPropertyTrackingUnusedProperties(final Set<String> propertyKeys, final String disableWarningKey, final String disableWarningValue) {
        log.logf(FQCN, WARN, null, configurationPropertyTrackingUnusedProperties$str(), propertyKeys, disableWarningKey, disableWarningValue);
    }
    protected String configurationPropertyTrackingUnusedProperties$str() {
        return "HSEARCH000568: Invalid configuration passed to Hibernate Search: some properties in the given configuration are not used. There might be misspelled property keys in your configuration. Unused properties: %1$s. To disable this warning, set the property '%2$s' to '%3$s'.";
    }
    protected String obsoleteConfigurationPropertiesFromSearch5$str() {
        return "HSEARCH000573: Invalid configuration passed to Hibernate Search: some properties in the given configuration are obsolete.Configuration properties changed between Hibernate Search 5 and Hibernate Search 6 Check out the reference documentation and upgrade your configuration. Obsolete properties: %1$s.";
    }
    @Override
    public final SearchException obsoleteConfigurationPropertiesFromSearch5(final Set<String> propertyKeys) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), obsoleteConfigurationPropertiesFromSearch5$str(), propertyKeys));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDefaultBackendRegistered$str() {
        return "HSEARCH000575: No default backend. Check that at least one entity is configured to target the default backend. The following backends can be retrieved by name: %1$s.";
    }
    @Override
    public final SearchException noDefaultBackendRegistered(final Collection<String> validBackendNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noDefaultBackendRegistered$str(), validBackendNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noBackendFactoryRegistered$str() {
        return "HSEARCH000581: Unable to resolve backend type: configuration property '%1$s' is not set, and there isn't any backend in the classpath. Check that you added the desired backend to your project's dependencies.";
    }
    @Override
    public final SearchException noBackendFactoryRegistered(final String propertyKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noBackendFactoryRegistered$str(), propertyKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleBackendFactoriesRegistered$str() {
        return "HSEARCH000582: Ambiguous backend type: configuration property '%1$s' is not set, and multiple backend types are present in the classpath. Set property '%1$s' to one of the following to select the backend type: %2$s";
    }
    @Override
    public final SearchException multipleBackendFactoriesRegistered(final String propertyKey, final Collection<String> backendTypeNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleBackendFactoriesRegistered$str(), propertyKey, backendTypeNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentMultiTenancyNamedBackend$str() {
        return "HSEARCH000596: Different mappings trying to define two backends with the same name '%1$s' but having different expectations on multi-tenancy.";
    }
    @Override
    public final SearchException differentMultiTenancyNamedBackend(final String backendName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentMultiTenancyNamedBackend$str(), backendName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentMultiTenancyDefaultBackend$str() {
        return "HSEARCH000597: Different mappings trying to define default backends having different expectations on multi-tenancy.";
    }
    @Override
    public final SearchException differentMultiTenancyDefaultBackend() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentMultiTenancyDefaultBackend$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ignoringServiceConfigurationError(final Class<?> serviceContract, final ServiceConfigurationError error) {
        log.logf(FQCN, DEBUG, error, ignoringServiceConfigurationError$str(), serviceContract);
    }
    protected String ignoringServiceConfigurationError$str() {
        return "HSEARCH000616: Ignoring ServiceConfigurationError caught while trying to instantiate service '%s'.";
    }
    @Override
    public final void multipleConfigurationProvidersAvailable(final String scope, final List<org.hibernate.search.engine.cfg.spi.ConfigurationProvider> configurationProviders) {
        log.logf(FQCN, DEBUG, null, multipleConfigurationProvidersAvailable$str(), scope, configurationProviders);
    }
    protected String multipleConfigurationProvidersAvailable$str() {
        return "HSEARCH000620: Multiple configuration providers are available for scope '%1$s'. They will be taken under consideration in the following order: '%2$s'.";
    }
}
