/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.common.spi;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.hibernate.search.engine.backend.scope.spi.AbstractSearchIndexScope;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.logging.impl.QueryLog;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.spi.SearchIndexIdentifierContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.reporting.EventContext;

public class MultiIndexSearchIndexIdentifierContext
implements SearchIndexIdentifierContext {
    private final SearchIndexScope<?> scope;
    private final List<SearchIndexIdentifierContext> contextByIndex;

    public MultiIndexSearchIndexIdentifierContext(AbstractSearchIndexScope<?, ?, ?, ?> scope, List<SearchIndexIdentifierContext> contextByIndex) {
        this.scope = scope;
        this.contextByIndex = contextByIndex;
    }

    public EventContext eventContext() {
        return this.scope.eventContext().append(this.relativeEventContext());
    }

    @Override
    public EventContext relativeEventContext() {
        return EventContexts.indexSchemaIdentifier();
    }

    @Override
    public DslConverter<?, String> mappingDslConverter() {
        return this.fromContextsIfCompatible(SearchIndexIdentifierContext::mappingDslConverter, DslConverter::isCompatibleWith, "mappingDslConverter");
    }

    @Override
    public DslConverter<?, String> parserDslConverter() {
        return this.fromContextsIfCompatible(SearchIndexIdentifierContext::parserDslConverter, DslConverter::isCompatibleWith, "parserDslConverter");
    }

    @Override
    public ProjectionConverter<String, ?> mappingProjectionConverter() {
        return this.fromContextsIfCompatible(SearchIndexIdentifierContext::mappingProjectionConverter, ProjectionConverter::isCompatibleWith, "mappingProjectionConverter");
    }

    protected final <T> T fromContextsIfCompatible(Function<SearchIndexIdentifierContext, T> getter, BiPredicate<T, T> compatibilityChecker, String attributeName) {
        T attribute = null;
        for (SearchIndexIdentifierContext context : this.contextByIndex) {
            T attributeForContext = getter.apply(context);
            if (attribute == null) {
                attribute = attributeForContext;
                continue;
            }
            this.checkAttributeCompatibility(compatibilityChecker, attributeName, attribute, attributeForContext);
        }
        return attribute;
    }

    private <T> void checkAttributeCompatibility(BiPredicate<T, T> compatibilityChecker, String attributeName, T attribute1, T attribute2) {
        try {
            if (!compatibilityChecker.test(attribute1, attribute2)) {
                throw QueryLog.INSTANCE.differentAttribute(attributeName, attribute1, attribute2);
            }
        }
        catch (SearchException e) {
            throw QueryLog.INSTANCE.inconsistentConfigurationInContextForSearch(this.relativeEventContext(), e.getMessage(), this.scope.eventContext(), e);
        }
    }
}

