/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.projection.definition.spi;

import java.util.List;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.projection.ProjectionCollector;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.definition.ProjectionDefinitionContext;
import org.hibernate.search.engine.search.projection.definition.spi.AbstractProjectionDefinition;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;

@Incubating
public abstract class FieldProjectionDefinition<P, F>
extends AbstractProjectionDefinition<P> {
    protected final String fieldPath;
    protected final Class<F> fieldType;
    protected final ValueModel valueModel;

    private FieldProjectionDefinition(String fieldPath, Class<F> fieldType, ValueModel valueModel) {
        this.fieldPath = fieldPath;
        this.fieldType = fieldType;
        this.valueModel = valueModel;
    }

    @Override
    protected String type() {
        return "field";
    }

    @Override
    public void appendTo(ToStringTreeAppender appender) {
        super.appendTo(appender);
        appender.attribute("fieldPath", (Object)this.fieldPath).attribute("fieldType", this.fieldType).attribute("multi", (Object)this.multi()).attribute("valueModel", (Object)this.valueModel);
    }

    protected abstract boolean multi();

    @Incubating
    public static final class AccumulatedValued<C, F>
    extends FieldProjectionDefinition<C, F> {
        private final ProjectionCollector.Provider<F, C> collector;

        public AccumulatedValued(String fieldPath, Class<F> fieldType, ProjectionCollector.Provider<F, C> collector, ValueModel valueModel) {
            super(fieldPath, fieldType, valueModel);
            this.collector = collector;
        }

        @Override
        protected boolean multi() {
            return !this.collector.isSingleValued();
        }

        @Override
        public SearchProjection<C> create(SearchProjectionFactory<?, ?> factory, ProjectionDefinitionContext context) {
            return factory.field(this.fieldPath, this.fieldType, this.valueModel).collector(this.collector).toProjection();
        }
    }

    @Deprecated(since="8.0")
    @Incubating
    public static final class MultiValued<F>
    extends FieldProjectionDefinition<List<F>, F> {
        public MultiValued(String fieldPath, Class<F> fieldType, ValueModel valueModel) {
            super(fieldPath, fieldType, valueModel);
        }

        @Override
        protected boolean multi() {
            return true;
        }

        @Override
        public SearchProjection<List<F>> create(SearchProjectionFactory<?, ?> factory, ProjectionDefinitionContext context) {
            return factory.field(this.fieldPath, this.fieldType, this.valueModel).collector(ProjectionCollector.list()).toProjection();
        }
    }

    @Deprecated(since="8.0")
    @Incubating
    public static final class SingleValued<F>
    extends FieldProjectionDefinition<F, F> {
        public SingleValued(String fieldPath, Class<F> fieldType, ValueModel valueModel) {
            super(fieldPath, fieldType, valueModel);
        }

        @Override
        protected boolean multi() {
            return false;
        }

        @Override
        public SearchProjection<F> create(SearchProjectionFactory<?, ?> factory, ProjectionDefinitionContext context) {
            return factory.field(this.fieldPath, this.fieldType, this.valueModel).toProjection();
        }
    }
}

