/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.logging.impl.EngineMiscLog;
import org.hibernate.search.util.common.AssertionFailure;

public class BeanReferenceRegistryForType<T> {
    private final Class<T> exposedType;
    private final List<BeanReference<T>> all = new ArrayList<BeanReference<T>>();
    private final Map<String, BeanReference<T>> named = new TreeMap<String, BeanReference<T>>();

    public BeanReferenceRegistryForType(Class<T> exposedType) {
        this.exposedType = exposedType;
    }

    public final List<BeanReference<T>> all() {
        return Collections.unmodifiableList(this.all);
    }

    public Map<String, BeanReference<T>> named() {
        return Collections.unmodifiableMap(this.named);
    }

    public BeanReference<T> single() {
        if (this.all.size() == 1) {
            return this.all.get(0);
        }
        if (this.all.size() > 1) {
            throw EngineMiscLog.INSTANCE.multipleConfiguredBeanReferencesForType(this.exposedType, this.all);
        }
        return null;
    }

    public BeanReference<T> named(String name) {
        return this.named.get(name);
    }

    void add(BeanReference<? extends T> reference) {
        this.all.add(reference);
    }

    void add(String name, BeanReference<? extends T> reference) {
        BeanReference<? extends T> previous = this.named.putIfAbsent(name, reference);
        if (previous != null) {
            throw new AssertionFailure(String.format(Locale.ROOT, "Duplicate bean references for name '%1$s': %2$s, %3$s", name, previous, reference));
        }
        this.all.add(reference);
    }
}

