/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@CategorizedLogger(category="org.hibernate.search.executor", description="Logs related to various Hibernate Search internal executors.\n")
@MessageLogger(projectCode="HSEARCH")
public interface ExecutorLog
extends BasicLogger {
    public static final String CATEGORY_NAME = "org.hibernate.search.executor";
    public static final ExecutorLog INSTANCE = (ExecutorLog)LoggerFactory.make(ExecutorLog.class, (String)"org.hibernate.search.executor", (MethodHandles.Lookup)MethodHandles.lookup());

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=230, value="Starting executor '%1$s'")
    public void startingExecutor(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=231, value="Stopping executor '%1$s'")
    public void stoppingExecutor(String var1);

    @Message(id=562, value="Unable to submit work to '%1$s': thread received interrupt signal. The work has been discarded.")
    public SearchException threadInterruptedWhileSubmittingWork(String var1);

    @Message(id=563, value="Unable to submit work to '%1$s': this orchestrator is stopped. The work has been discarded.")
    public SearchException submittedWorkToStoppedOrchestrator(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=630, value="Processing %d works in executor '%s'")
    public void numberOfWorksInExecutor(int var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=631, value="Processed %d works in executor '%s'")
    public void numberOfProcessedWorksInExecutor(int var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=632, value="Scheduling task '%s'.")
    public void schedulingTask(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=633, value="Running task '%s'")
    public void runningTask(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=634, value="Completed task '%s'")
    public void completedTask(String var1);
}

