/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.impl;

import java.util.Set;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.schema.management.spi.IndexSchemaManager;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexManager;
import org.hibernate.search.engine.mapper.scope.impl.MappedIndexScopeBuilderImpl;
import org.hibernate.search.engine.mapper.scope.spi.MappedIndexScopeBuilder;

public class MappedIndexManagerImpl
implements MappedIndexManager {
    private final IndexManagerImplementor implementor;

    public MappedIndexManagerImpl(IndexManagerImplementor implementor) {
        this.implementor = implementor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[implementor=" + String.valueOf(this.implementor) + "]";
    }

    @Override
    public IndexManager toAPI() {
        return this.implementor.toAPI();
    }

    @Override
    public IndexSchemaManager schemaManager() {
        return this.implementor.schemaManager();
    }

    @Override
    public IndexIndexingPlan createIndexingPlan(BackendSessionContext sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.implementor.createIndexingPlan(sessionContext, commitStrategy, refreshStrategy);
    }

    @Override
    public IndexIndexer createIndexer(BackendSessionContext sessionContext) {
        return this.implementor.createIndexer(sessionContext);
    }

    @Override
    public IndexWorkspace createWorkspace(BackendMappingContext mappingContext, Set<String> tenantIds) {
        return this.implementor.createWorkspace(mappingContext, tenantIds);
    }

    @Override
    public <SR, R, E> MappedIndexScopeBuilder<SR, R, E> createScopeBuilder(BackendMappingContext mappingContext) {
        return new MappedIndexScopeBuilderImpl(this.implementor, mappingContext);
    }

    @Override
    public void addTo(MappedIndexScopeBuilder<?, ?, ?> builder) {
        ((MappedIndexScopeBuilderImpl)builder).add(this.implementor);
    }
}

