/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.GenericSimpleBooleanPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.SimpleBooleanPredicateClausesCollector;
import org.hibernate.search.engine.search.predicate.dsl.spi.AbstractPredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.predicate.spi.BooleanPredicateBuilder;

public abstract class AbstractSimpleBooleanPredicateClausesStep<SR, S extends C, C extends SimpleBooleanPredicateClausesCollector<SR, ?>>
extends AbstractPredicateFinalStep
implements GenericSimpleBooleanPredicateClausesStep<SR, S, C> {
    private final SimpleBooleanPredicateOperator operator;
    private final BooleanPredicateBuilder builder;
    private final SearchPredicateFactory<SR> factory;

    AbstractSimpleBooleanPredicateClausesStep(SimpleBooleanPredicateOperator operator, SearchPredicateDslContext<?> dslContext, SearchPredicateFactory<SR> factory) {
        super(dslContext);
        this.operator = operator;
        this.builder = dslContext.scope().predicateBuilders().bool();
        this.factory = factory;
    }

    protected abstract S self();

    @Override
    public S add(SearchPredicate searchPredicate) {
        this.operator.accept(this.builder, searchPredicate);
        return this.self();
    }

    @Override
    public S add(Function<? super SearchPredicateFactory<SR>, ? extends PredicateFinalStep> clauseContributor) {
        return this.add(clauseContributor.apply(this.factory));
    }

    public S boost(float boost) {
        this.builder.boost(boost);
        return this.self();
    }

    public S constantScore() {
        this.builder.constantScore();
        return this.self();
    }

    @Override
    public S with(Consumer<? super C> contributor) {
        contributor.accept(this.self());
        return this.self();
    }

    @Override
    public boolean hasClause() {
        return this.builder.hasClause();
    }

    @Override
    protected SearchPredicate build() {
        return this.builder.build();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SimpleBooleanPredicateOperator implements BiConsumer<BooleanPredicateBuilder, SearchPredicate>
    {
        AND{

            @Override
            public void accept(BooleanPredicateBuilder builder, SearchPredicate searchPredicate) {
                builder.must(searchPredicate);
            }
        }
        ,
        OR{

            @Override
            public void accept(BooleanPredicateBuilder builder, SearchPredicate searchPredicate) {
                builder.should(searchPredicate);
            }
        };

    }
}

