/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.util.function.Function;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.MatchAllPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.spi.AbstractPredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.predicate.spi.BooleanPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchAllPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilder;

public final class MatchAllPredicateOptionsStepImpl<SR>
extends AbstractPredicateFinalStep
implements MatchAllPredicateOptionsStep<SR, MatchAllPredicateOptionsStep<SR, ?>> {
    private final SearchPredicateFactory<SR> factory;
    private final MatchAllPredicateBuilder matchAllBuilder;
    private MatchAllExceptState exceptState;
    private Float boost;
    private boolean constantScore = false;

    public MatchAllPredicateOptionsStepImpl(SearchPredicateDslContext<?> dslContext, SearchPredicateFactory<SR> factory) {
        super(dslContext);
        this.factory = factory;
        this.matchAllBuilder = dslContext.scope().predicateBuilders().matchAll();
    }

    @Override
    public MatchAllPredicateOptionsStep<SR, ?> boost(float boost) {
        this.boost = Float.valueOf(boost);
        return this;
    }

    @Override
    public MatchAllPredicateOptionsStep<SR, ?> constantScore() {
        this.constantScore = true;
        return this;
    }

    @Override
    public MatchAllPredicateOptionsStep<SR, ?> except(SearchPredicate searchPredicate) {
        this.getExceptState().addClause(searchPredicate);
        return this;
    }

    @Override
    public MatchAllPredicateOptionsStep<SR, ?> except(Function<? super SearchPredicateFactory<SR>, ? extends PredicateFinalStep> clauseContributor) {
        this.getExceptState().addClause(clauseContributor);
        return this;
    }

    @Override
    protected SearchPredicate build() {
        SearchPredicateBuilder builder = this.exceptState != null ? this.exceptState.builder(this.matchAllBuilder.build()) : this.matchAllBuilder;
        if (this.constantScore) {
            builder.constantScore();
        }
        if (this.boost != null) {
            builder.boost(this.boost.floatValue());
        }
        return builder.build();
    }

    private MatchAllExceptState getExceptState() {
        if (this.exceptState == null) {
            this.exceptState = new MatchAllExceptState();
        }
        return this.exceptState;
    }

    private class MatchAllExceptState {
        private final BooleanPredicateBuilder booleanBuilder;

        MatchAllExceptState() {
            this.booleanBuilder = MatchAllPredicateOptionsStepImpl.this.dslContext.scope().predicateBuilders().bool();
        }

        void addClause(Function<? super SearchPredicateFactory<SR>, ? extends PredicateFinalStep> clauseContributor) {
            this.addClause(clauseContributor.apply(MatchAllPredicateOptionsStepImpl.this.factory).toPredicate());
        }

        void addClause(SearchPredicate predicate) {
            this.booleanBuilder.mustNot(predicate);
        }

        SearchPredicateBuilder builder(SearchPredicate matchAll) {
            this.booleanBuilder.must(matchAll);
            return this.booleanBuilder;
        }
    }
}

