/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.sort.dsl.impl;

import java.util.function.Function;
import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactoryExtension;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactoryExtensionIfSupportedMoreStep;
import org.hibernate.search.engine.search.sort.dsl.SortFinalStep;
import org.hibernate.search.engine.search.sort.dsl.SortThenStep;
import org.hibernate.search.engine.search.sort.dsl.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.sort.dsl.spi.StaticSortThenStep;

public final class SearchSortFactoryExtensionStep<SR>
implements SearchSortFactoryExtensionIfSupportedMoreStep<SR> {
    private final SearchSortFactory<SR> parent;
    private final SearchSortDslContext<SR, ?, ?> dslContext;
    private final DslExtensionState<SortFinalStep> state = new DslExtensionState();

    public SearchSortFactoryExtensionStep(SearchSortFactory<SR> parent, SearchSortDslContext<SR, ?, ?> dslContext) {
        this.parent = parent;
        this.dslContext = dslContext;
    }

    @Override
    public <T> SearchSortFactoryExtensionIfSupportedMoreStep<SR> ifSupported(SearchSortFactoryExtension<SR, T> extension, Function<T, ? extends SortFinalStep> sortContributor) {
        this.state.ifSupported(extension, extension.extendOptional(this.parent), sortContributor);
        return this;
    }

    @Override
    public SortThenStep<SR> orElse(Function<SearchSortFactory<SR>, ? extends SortFinalStep> sortContributor) {
        SortFinalStep result = this.state.orElse(this.parent, sortContributor);
        return new StaticSortThenStep<SR>(this.dslContext, result.toSort());
    }

    @Override
    public SortThenStep<SR> orElseFail() {
        SortFinalStep result = this.state.orElseFail();
        return new StaticSortThenStep<SR>(this.dslContext, result.toSort());
    }
}

