/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.common.spi;

import java.util.Objects;
import org.hibernate.search.engine.logging.impl.MappingLog;
import org.hibernate.search.engine.logging.impl.QueryLog;
import org.hibernate.search.engine.reporting.impl.EngineHints;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.spi.SearchIndexCompositeNodeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexNodeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;
import org.hibernate.search.engine.search.common.spi.SearchIndexValueFieldContext;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementFactory;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.reporting.EventContext;

public abstract class SearchIndexSchemaElementContextHelper {
    public static final SearchIndexSchemaElementContextHelper VALUE_FIELD = new SearchIndexSchemaElementContextHelper(){

        @Override
        protected String missingSupportHint(SearchQueryElementTypeKey<?> key) {
            return EngineHints.INSTANCE.missingSupportHintForValueField(key);
        }

        @Override
        public String partialSupportHint() {
            return EngineHints.INSTANCE.partialSupportHintForValueField();
        }
    };
    public static final SearchIndexSchemaElementContextHelper COMPOSITE = new SearchIndexSchemaElementContextHelper(){

        @Override
        protected String missingSupportHint(SearchQueryElementTypeKey<?> key) {
            return EngineHints.INSTANCE.missingSupportHintForCompositeNode();
        }

        @Override
        public String partialSupportHint() {
            return EngineHints.INSTANCE.partialSupportHintForCompositeNode();
        }
    };

    public static <T extends SearchIndexCompositeNodeContext<?>> T throwingToComposite(SearchIndexNodeContext<?> element) {
        throw MappingLog.INSTANCE.invalidIndexNodeTypeNotComposite(element.relativeEventContext());
    }

    public static <T extends SearchIndexCompositeNodeContext<?>> T throwingToObjectField(SearchIndexNodeContext<?> element) {
        throw MappingLog.INSTANCE.invalidIndexNodeTypeNotObjectField(element.relativeEventContext());
    }

    public static <T extends SearchIndexValueFieldContext<?>> T throwingToValueField(SearchIndexNodeContext<?> element) {
        throw MappingLog.INSTANCE.invalidIndexNodeTypeNotValueField(element.relativeEventContext());
    }

    public static void checkNestedDocumentPathCompatibility(SearchIndexNodeContext<?> left, SearchIndexNodeContext<?> right) {
        String rightNestedDocumentPathHierarchy;
        String leftNestedDocumentPathHierarchy = left.nestedDocumentPath();
        if (!Objects.equals(leftNestedDocumentPathHierarchy, rightNestedDocumentPathHierarchy = right.nestedDocumentPath())) {
            throw QueryLog.INSTANCE.targetFieldsSpanningMultipleNestedPaths(left.absolutePath(), SearchIndexSchemaElementContextHelper.pathEventContext(leftNestedDocumentPathHierarchy), right.absolutePath(), SearchIndexSchemaElementContextHelper.pathEventContext(rightNestedDocumentPathHierarchy));
        }
    }

    private static EventContext pathEventContext(String path) {
        return path == null ? EventContexts.indexSchemaRoot() : EventContexts.fromIndexFieldAbsolutePath(path);
    }

    private SearchIndexSchemaElementContextHelper() {
    }

    public <T, SC extends SearchIndexScope<?>, N extends SearchIndexNodeContext<SC>> T queryElement(SearchQueryElementTypeKey<T> key, SearchQueryElementFactory<? extends T, ? super SC, ? super N> factory, SC scope, N node) {
        if (factory == null) {
            throw this.cannotUseQueryElement(key, node, this.missingSupportHint(key), null);
        }
        try {
            return factory.create(scope, node);
        }
        catch (SearchException e) {
            throw this.cannotUseQueryElement(key, node, e.getMessage(), (Exception)((Object)e));
        }
    }

    public <T, SC extends SearchIndexScope<?>, N extends SearchIndexNodeContext<SC>> SearchException cannotUseQueryElement(SearchQueryElementTypeKey<T> key, N node, String hint, Exception causeOrNull) {
        throw QueryLog.INSTANCE.cannotUseQueryElementForIndexNode(node.relativeEventContext(), key, hint, node.eventContext(), causeOrNull);
    }

    protected abstract String missingSupportHint(SearchQueryElementTypeKey<?> var1);

    public abstract String partialSupportHint();
}

