/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.impl;

import java.util.Optional;
import java.util.function.Function;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConvertUtils;
import org.hibernate.search.engine.logging.impl.ConfigurationLog;

abstract class AbstractConfigurationProperty<T>
implements ConfigurationProperty<T> {
    private final String key;

    AbstractConfigurationProperty(String key) {
        this.key = key;
    }

    @Override
    public T get(ConfigurationPropertySource source) {
        return this.doGet(source, Function.identity());
    }

    @Override
    public <R> R getAndTransform(ConfigurationPropertySource source, Function<T, R> transform) {
        return this.doGet(source, transform);
    }

    abstract <R> R convert(Optional<?> var1, Function<T, R> var2);

    <R> R doGet(ConfigurationPropertySource source, Function<T, R> transform) {
        Optional<Object> rawValue = source.get(this.key).map(ConvertUtils::trimIfString);
        try {
            return this.convert(rawValue, transform);
        }
        catch (RuntimeException e) {
            String displayedKey = this.key;
            try {
                Optional<String> resolvedKey = source.resolve(this.key);
                if (resolvedKey.isPresent()) {
                    displayedKey = resolvedKey.get();
                }
            }
            catch (RuntimeException e2) {
                e.addSuppressed(e2);
            }
            throw ConfigurationLog.INSTANCE.unableToConvertConfigurationProperty(displayedKey, rawValue.isPresent() ? rawValue.get() : "", e.getMessage(), e);
        }
    }

    @Override
    public Optional<String> resolve(ConfigurationPropertySource source) {
        return source.resolve(this.key);
    }

    @Override
    public String resolveOrRaw(ConfigurationPropertySource source) {
        return this.resolve(source).orElse(this.key);
    }
}

