/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.sort.dsl.spi;

import java.util.function.Function;
import org.hibernate.search.engine.search.predicate.dsl.TypedSearchPredicateFactory;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.TypedSearchSortFactory;
import org.hibernate.search.engine.search.sort.spi.CompositeSortBuilder;
import org.hibernate.search.engine.search.sort.spi.SearchSortIndexScope;

public final class SearchSortDslContext<SR, SC extends SearchSortIndexScope<?>, PDF extends TypedSearchPredicateFactory<SR>> {
    private final SC scope;
    private final Function<SearchSortDslContext<SR, SC, PDF>, TypedSearchSortFactory<SR>> factoryProvider;
    private final SearchSortDslContext<SR, ?, ?> parent;
    private final SearchSort sort;
    private final PDF predicateFactory;
    private SearchSort compositeSort;

    public static <SR, SC extends SearchSortIndexScope<?>, PDF extends TypedSearchPredicateFactory<SR>> SearchSortDslContext<SR, SC, PDF> root(SC scope, Function<SearchSortDslContext<SR, SC, PDF>, TypedSearchSortFactory<SR>> factoryProvider, PDF predicateFactory) {
        return new SearchSortDslContext<SR, SC, PDF>(scope, factoryProvider, null, null, predicateFactory);
    }

    private SearchSortDslContext(SC scope, Function<SearchSortDslContext<SR, SC, PDF>, TypedSearchSortFactory<SR>> factoryProvider, SearchSortDslContext<SR, ?, ?> parent, SearchSort sort, PDF predicateFactory) {
        this.scope = scope;
        this.factoryProvider = factoryProvider;
        this.parent = parent;
        this.sort = sort;
        this.predicateFactory = predicateFactory;
    }

    public SC scope() {
        return this.scope;
    }

    public TypedSearchSortFactory<SR> then() {
        return this.factoryProvider.apply(this);
    }

    public SearchSortDslContext<SR, SC, PDF> rescope(SC newScope, PDF newPredicateFactory) {
        return new SearchSortDslContext<SR, SC, PDF>(newScope, this.factoryProvider, this.parent, this.sort, newPredicateFactory);
    }

    public SearchSortDslContext<SR, SC, PDF> append(SearchSort sort) {
        return new SearchSortDslContext<SR, SC, PDF>(this.scope, this.factoryProvider, this, sort, this.predicateFactory);
    }

    public PDF predicateFactory() {
        return this.predicateFactory;
    }

    public SearchSort toSort() {
        if (this.compositeSort == null) {
            this.compositeSort = this.createCompositeSort();
        }
        return this.compositeSort;
    }

    private SearchSort createCompositeSort() {
        if (this.parent == null) {
            return this.scope.sortBuilders().composite().build();
        }
        if (this.parent.sort == null) {
            return this.sort;
        }
        CompositeSortBuilder builder = this.scope.sortBuilders().composite();
        this.collectSorts(builder);
        return builder.build();
    }

    private void collectSorts(CompositeSortBuilder builder) {
        if (this.sort == null) {
            return;
        }
        this.parent.collectSorts(builder);
        builder.add(this.sort);
    }
}

