/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.search.engine.logging.impl.QueryLog;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateFieldMoreGenericStep;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.engine.search.reference.predicate.RangePredicateFieldReference;
import org.hibernate.search.engine.search.reference.predicate.TypedPredicateFieldReference;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.reporting.EventContext;

abstract class AbstractRangePredicateFieldMoreStep<SR, CS extends GenericCommonState<SR, T, V, S>, S extends AbstractRangePredicateFieldMoreStep<SR, CS, S, T, V>, T, V>
implements AbstractBooleanMultiFieldPredicateCommonState.FieldSetState {
    protected final CS commonState;
    private final List<V> fields;
    private final List<RangePredicateBuilder> predicateBuilders = new ArrayList<RangePredicateBuilder>();
    private Float fieldSetBoost;

    static <SR> RangePredicateFieldMoreStepString<SR> create(SearchPredicateDslContext<?> dslContext, String[] fields) {
        return new RangePredicateFieldMoreStepString(dslContext, Arrays.asList(fields));
    }

    static <SR, T> RangePredicateFieldMoreStepReference<SR, T> create(SearchPredicateDslContext<?> dslContext, RangePredicateFieldReference<? super SR, T>[] fields) {
        List<RangePredicateFieldReference<? super SR, T>> fieldsList = Arrays.asList(fields);
        return new RangePredicateFieldMoreStepReference<SR, T>(dslContext, fieldsList);
    }

    private AbstractRangePredicateFieldMoreStep(CS commonState, List<V> fields) {
        this.commonState = commonState;
        ((AbstractBooleanMultiFieldPredicateCommonState)this.commonState).add((AbstractRangePredicateFieldMoreStep)this);
        this.fields = fields;
        for (V field : fields) {
            ((AbstractBooleanMultiFieldPredicateCommonState)commonState).scope().fieldQueryElement(this.fieldPath(field), PredicateTypeKeys.RANGE);
        }
    }

    protected abstract String fieldPath(V var1);

    protected abstract S thisAsS();

    public S boost(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this.thisAsS();
    }

    @Override
    public void contributePredicates(Consumer<SearchPredicate> collector) {
        for (RangePredicateBuilder predicateBuilder : this.predicateBuilders) {
            ((AbstractBooleanMultiFieldPredicateCommonState)this.commonState).applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.build());
        }
    }

    private static class RangePredicateFieldMoreStepString<SR>
    extends AbstractRangePredicateFieldMoreStep<SR, CommonState<SR>, RangePredicateFieldMoreStepString<SR>, Object, String>
    implements RangePredicateFieldMoreStep<SR, RangePredicateFieldMoreStepString<SR>, CommonState<SR>> {
        private RangePredicateFieldMoreStepString(SearchPredicateDslContext<?> dslContext, List<String> fields) {
            this(new CommonState(dslContext), fields);
        }

        private RangePredicateFieldMoreStepString(CommonState<SR> commonState, List<String> fields) {
            super(commonState, fields);
        }

        @Override
        protected String fieldPath(String field) {
            return field;
        }

        @Override
        protected RangePredicateFieldMoreStepString<SR> thisAsS() {
            return this;
        }

        @Override
        public RangePredicateFieldMoreStepString<SR> fields(String ... fieldPaths) {
            return new RangePredicateFieldMoreStepString<SR>((CommonState)this.commonState, Arrays.asList(fieldPaths));
        }

        @Override
        public CommonState<SR> within(Range<?> range, ValueModel convert) {
            Contracts.assertNotNull(range, (String)"range");
            Contracts.assertNotNull((Object)((Object)convert), (String)"convert");
            return (CommonState)((CommonState)this.commonState).within(range, (V v) -> convert);
        }

        @Override
        public CommonState<SR> withinAny(Collection<? extends Range<?>> ranges, ValueModel valueModel) {
            Contracts.assertNotNull(ranges, (String)"ranges");
            Contracts.assertNotNull((Object)((Object)valueModel), (String)"convert");
            return (CommonState)((CommonState)this.commonState).withinAny((Collection)ranges, (T v) -> valueModel);
        }

        public static class CommonState<SR>
        extends GenericCommonState<SR, Object, String, RangePredicateFieldMoreStepString<SR>> {
            CommonState(SearchPredicateDslContext<?> dslContext) {
                super(dslContext);
            }

            @Override
            protected String fieldPath(String field) {
                return field;
            }
        }
    }

    private static class RangePredicateFieldMoreStepReference<SR, T>
    extends AbstractRangePredicateFieldMoreStep<SR, CommonState<SR, T>, RangePredicateFieldMoreStepReference<SR, T>, T, RangePredicateFieldReference<? super SR, T>>
    implements RangePredicateFieldMoreGenericStep<SR, RangePredicateFieldMoreStepReference<SR, T>, CommonState<SR, T>, RangePredicateFieldReference<? super SR, T>, T> {
        private RangePredicateFieldMoreStepReference(SearchPredicateDslContext<?> dslContext, List<RangePredicateFieldReference<? super SR, T>> fields) {
            this(new CommonState(dslContext), fields);
        }

        private RangePredicateFieldMoreStepReference(CommonState<SR, T> commonState, List<RangePredicateFieldReference<? super SR, T>> fields) {
            super(commonState, fields);
        }

        @Override
        protected String fieldPath(RangePredicateFieldReference<? super SR, T> field) {
            return field.absolutePath();
        }

        @Override
        protected RangePredicateFieldMoreStepReference<SR, T> thisAsS() {
            return this;
        }

        @Override
        public RangePredicateFieldMoreStepReference<SR, T> field(RangePredicateFieldReference<? super SR, T> field) {
            return new RangePredicateFieldMoreStepReference<SR, T>((CommonState)this.commonState, List.of(field));
        }

        public RangePredicateFieldMoreStepReference<SR, T> fields(RangePredicateFieldReference<? super SR, T> ... fields) {
            return new RangePredicateFieldMoreStepReference<SR, T>((CommonState)this.commonState, Arrays.asList(fields));
        }

        @Override
        public CommonState<SR, T> within(Range<? extends T> range) {
            return (CommonState)((CommonState)this.commonState).within(range, TypedPredicateFieldReference::valueModel);
        }

        @Override
        public CommonState<SR, T> withinAny(Collection<? extends Range<?>> ranges, ValueModel valueModel) {
            return (CommonState)((CommonState)this.commonState).withinAny((Collection)ranges, TypedPredicateFieldReference::valueModel);
        }

        public static class CommonState<SR, T>
        extends GenericCommonState<SR, T, RangePredicateFieldReference<? super SR, T>, RangePredicateFieldMoreStepReference<SR, T>> {
            CommonState(SearchPredicateDslContext<?> dslContext) {
                super(dslContext);
            }

            @Override
            protected String fieldPath(RangePredicateFieldReference<? super SR, T> field) {
                return field.absolutePath();
            }
        }
    }

    static abstract class GenericCommonState<SR, T, V, S extends AbstractRangePredicateFieldMoreStep<SR, ?, S, T, V>>
    extends AbstractBooleanMultiFieldPredicateCommonState<GenericCommonState<SR, T, V, S>, AbstractRangePredicateFieldMoreStep<SR, ?, S, T, V>>
    implements RangePredicateOptionsStep<GenericCommonState<SR, T, V, S>> {
        GenericCommonState(SearchPredicateDslContext<?> dslContext) {
            super(dslContext);
        }

        @Override
        protected GenericCommonState<SR, T, V, S> thisAsS() {
            return this;
        }

        protected abstract String fieldPath(V var1);

        GenericCommonState<SR, T, V, S> within(Range<?> range, Function<V, ValueModel> valueModelFunction) {
            if (range.lowerBoundValue().isEmpty() && range.upperBoundValue().isEmpty()) {
                throw QueryLog.INSTANCE.rangePredicateCannotMatchNullValue(this.getEventContext());
            }
            for (AbstractRangePredicateFieldMoreStep fieldSetState : this.getFieldSetStates()) {
                for (Object field : fieldSetState.fields) {
                    ValueModel valueModel = valueModelFunction.apply(field);
                    RangePredicateBuilder builder = this.scope().fieldQueryElement(this.fieldPath(field), PredicateTypeKeys.RANGE);
                    builder.within(range, valueModel, valueModel);
                    fieldSetState.predicateBuilders.add(builder);
                }
            }
            return this;
        }

        public GenericCommonState<SR, T, V, S> withinAny(Collection<? extends Range<?>> ranges, Function<V, ValueModel> valueModelFunction) {
            for (AbstractRangePredicateFieldMoreStep fieldSetState : this.getFieldSetStates()) {
                for (Object field : fieldSetState.fields) {
                    for (Range<?> range : ranges) {
                        Contracts.assertNotNull(range, (String)"range");
                        if (range.lowerBoundValue().isEmpty() && range.upperBoundValue().isEmpty()) {
                            throw QueryLog.INSTANCE.rangePredicateCannotMatchNullValue(this.getEventContext());
                        }
                        ValueModel valueModel = valueModelFunction.apply(field);
                        RangePredicateBuilder builder = this.scope().fieldQueryElement(this.fieldPath(field), PredicateTypeKeys.RANGE);
                        builder.within(range, valueModel, valueModel);
                        fieldSetState.predicateBuilders.add(builder);
                    }
                }
            }
            return this;
        }

        protected final EventContext getEventContext() {
            return EventContexts.fromIndexFieldAbsolutePaths(this.getFieldSetStates().stream().flatMap(f -> f.fields.stream()).map(this::fieldPath).toList());
        }
    }
}

