/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.projection.dsl.impl;

import java.util.HashMap;
import java.util.List;
import org.hibernate.search.engine.backend.reporting.spi.BackendMappingHints;
import org.hibernate.search.engine.logging.impl.QueryLog;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.EntityProjectionOptionsStep;
import org.hibernate.search.engine.search.projection.dsl.TypedSearchProjectionFactory;
import org.hibernate.search.engine.search.projection.dsl.spi.SearchProjectionDslContext;
import org.hibernate.search.engine.search.projection.spi.ProjectionMappedTypeContext;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionIndexScope;

public final class EntityProjectionOptionsStepImpl<SR, E>
implements EntityProjectionOptionsStep<EntityProjectionOptionsStepImpl<SR, E>, E> {
    private final SearchProjectionIndexScope<?> scope;
    private final TypedSearchProjectionFactory<SR, ?, ?> projectionFactory;
    private final Class<E> requestedEntityType;

    public EntityProjectionOptionsStepImpl(SearchProjectionDslContext<?> dslContext, TypedSearchProjectionFactory<SR, ?, ?> projectionFactory, Class<E> requestedEntityType) {
        this.scope = dslContext.scope();
        this.projectionFactory = projectionFactory;
        this.requestedEntityType = requestedEntityType;
    }

    @Override
    public SearchProjection<E> toProjection() {
        List<ProjectionMappedTypeContext> mappedTypeContexts = this.scope.mappedTypeContexts();
        boolean canUseProjectionFromFirst = true;
        ProjectionMappedTypeContext first = mappedTypeContexts.get(0);
        for (ProjectionMappedTypeContext mappedTypeContext : mappedTypeContexts) {
            boolean willYieldSameProjectionAsFirst = first.loadingAvailable() ? mappedTypeContext.loadingAvailable() : first.javaClass().equals(mappedTypeContext.javaClass());
            if (willYieldSameProjectionAsFirst) continue;
            canUseProjectionFromFirst = false;
            break;
        }
        if (canUseProjectionFromFirst) {
            return this.toProjection(first);
        }
        HashMap<String, SearchProjection<E>> byTypeName = new HashMap<String, SearchProjection<E>>();
        for (ProjectionMappedTypeContext mappedTypeContext : mappedTypeContexts) {
            byTypeName.put(mappedTypeContext.name(), this.toProjection(mappedTypeContext));
        }
        return this.scope.projectionBuilders().byTypeName(byTypeName);
    }

    private SearchProjection<E> toProjection(ProjectionMappedTypeContext mappedTypeContext) {
        if (this.requestedEntityType != null && !this.requestedEntityType.isAssignableFrom(mappedTypeContext.javaClass())) {
            throw QueryLog.INSTANCE.invalidTypeForEntityProjection(mappedTypeContext.name(), mappedTypeContext.javaClass(), this.requestedEntityType);
        }
        if (mappedTypeContext.loadingAvailable()) {
            return this.scope.projectionBuilders().entityLoading();
        }
        Class<?> javaClass = mappedTypeContext.javaClass();
        if (this.scope.projectionRegistry().compositeOptional(javaClass).isPresent()) {
            return this.scope.projectionBuilders().entityComposite(this.projectionFactory.composite().as(javaClass).toProjection());
        }
        BackendMappingHints hints = this.scope.mappingContext().hints();
        return this.scope.projectionBuilders().throwing(() -> QueryLog.INSTANCE.cannotCreateEntityProjection(mappedTypeContext.name(), mappedTypeContext.javaClass(), hints.noEntityProjectionAvailable()));
    }
}

