/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.spatial;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.engine.logging.impl.FormattingLog;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.engine.spatial.GeoPolygon;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.impl.Contracts;

final class ImmutableGeoPolygon
implements GeoPolygon {
    private List<GeoPoint> points;

    ImmutableGeoPolygon(List<GeoPoint> points) {
        Contracts.assertNotNull(points, (String)"points");
        GeoPoint firstPoint = points.get(0);
        GeoPoint lastPoint = points.get(points.size() - 1);
        if (!firstPoint.equals(lastPoint)) {
            throw FormattingLog.INSTANCE.invalidGeoPolygonFirstPointNotIdenticalToLastPoint(firstPoint, lastPoint);
        }
        this.points = CollectionHelper.toImmutableList(new ArrayList<GeoPoint>(points));
    }

    @Override
    public List<GeoPoint> points() {
        return this.points;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableGeoPolygon that = (ImmutableGeoPolygon)obj;
        return that.points.equals(this.points);
    }

    public int hashCode() {
        return this.points.hashCode();
    }

    public String toString() {
        return "ImmutableGeoPolygon[points=" + String.valueOf(this.points) + "]";
    }
}

