/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batch.jsr352.jberet.impl;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import org.hibernate.search.batch.jsr352.core.inject.scope.spi.HibernateSearchJobScoped;
import org.hibernate.search.batch.jsr352.core.inject.scope.spi.HibernateSearchPartitionScoped;
import org.hibernate.search.batch.jsr352.core.massindexing.spi.JobContextSetupListener;
import org.hibernate.search.batch.jsr352.core.massindexing.step.lucene.spi.EntityReader;
import org.jberet.cdi.JobScoped;
import org.jberet.cdi.PartitionScoped;

public class HibernateSearchJsr352Extension
implements Extension {
    public void afterTypeDiscovery(@Observes AfterTypeDiscovery event, BeanManager beanManager) {
        this.registerType(event, beanManager, JobContextSetupListener.class);
        this.registerType(event, beanManager, EntityReader.class);
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        this.addScopeAlias(event, beanManager, HibernateSearchJobScoped.class, JobScoped.class);
        this.addScopeAlias(event, beanManager, HibernateSearchPartitionScoped.class, PartitionScoped.class);
    }

    private void registerType(AfterTypeDiscovery event, BeanManager beanManager, Class<?> clazz) {
        AnnotatedType annotatedType = beanManager.createAnnotatedType(clazz);
        event.addAnnotatedType(annotatedType, clazz.getName());
    }

    private void addScopeAlias(AfterBeanDiscovery event, BeanManager beanManager, Class<? extends Annotation> alias, Class<? extends Annotation> target) {
        event.addContext((Context)new AliasedContext(alias, beanManager, target));
    }

    private static class AliasedContext
    implements Context {
        private final Class<? extends Annotation> scopeType;
        private final BeanManager targetBeanManager;
        private final Class<? extends Annotation> targetScopeType;

        public AliasedContext(Class<? extends Annotation> scopeType, BeanManager targetBeanManager, Class<? extends Annotation> targetScopeType) {
            this.scopeType = scopeType;
            this.targetBeanManager = targetBeanManager;
            this.targetScopeType = targetScopeType;
        }

        private Context delegate() {
            return this.targetBeanManager.getContext(this.targetScopeType);
        }

        public Class<? extends Annotation> getScope() {
            return this.scopeType;
        }

        public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
            return (T)this.delegate().get(contextual, creationalContext);
        }

        public <T> T get(Contextual<T> contextual) {
            return (T)this.delegate().get(contextual);
        }

        public boolean isActive() {
            try {
                this.delegate();
                return true;
            }
            catch (ContextNotActiveException e) {
                return false;
            }
        }
    }
}

