package org.hibernate.search.batch.jsr352.jberet.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String noAvailableEntityManagerFactoryInCDI$str() {
        return "HSEARCH500002: No entity manager factory available in the CDI context with this bean name: '%1$s'. Make sure your entity manager factory is a named bean.";
    }
    @Override
    public final SearchException noAvailableEntityManagerFactoryInCDI(final String reference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noAvailableEntityManagerFactoryInCDI$str(), reference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unknownEntityManagerFactoryNamespace$str() {
        return "HSEARCH500003: Unknown entity manager factory namespace: '%1$s'. Use a supported namespace.";
    }
    @Override
    public final SearchException unknownEntityManagerFactoryNamespace(final String namespace) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownEntityManagerFactoryNamespace$str(), namespace));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotRetrieveEntityManagerFactoryInJsr352$str() {
        return "HSEARCH500004: Exception while retrieving the EntityManagerFactory using @PersistenceUnit. This generally happens either because persistence wasn't configured properly or because there are multiple persistence units.";
    }
    @Override
    public final SearchException cannotRetrieveEntityManagerFactoryInJsr352() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotRetrieveEntityManagerFactoryInJsr352$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ambiguousEntityManagerFactoryInJsr352$str() {
        return "HSEARCH500005: Multiple entity manager factories have been registered in the CDI context. Use the 'entityManagerFactoryReference' parameter to provide the bean name for the selected entity manager factory to the mass indexing job.";
    }
    @Override
    public final SearchException ambiguousEntityManagerFactoryInJsr352() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), ambiguousEntityManagerFactoryInJsr352$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
