/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jakarta.batch.jberet.context.jpa.impl;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Vetoed;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceUnit;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.jakarta.batch.core.context.jpa.spi.EntityManagerFactoryRegistry;
import org.hibernate.search.jakarta.batch.jberet.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

@ApplicationScoped
public class JBeretEntityManagerFactoryRegistry
implements EntityManagerFactoryRegistry {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String CDI_NAMESPACE_NAME = "cdi";
    @Inject
    private Instance<EntityManagerFactory> entityManagerFactoryInstance;
    @Inject
    private BeanManager beanManager;

    public EntityManagerFactory useDefault() {
        if (this.entityManagerFactoryInstance.isUnsatisfied()) {
            try {
                return JBeretEntityManagerFactoryRegistry.getVetoedBeanReference((BeanManager)this.beanManager, PersistenceUnitAccessor.class).entityManagerFactory;
            }
            catch (RuntimeException e) {
                throw log.cannotRetrieveEntityManagerFactoryInJakartaBatch();
            }
        }
        if (this.entityManagerFactoryInstance.isAmbiguous()) {
            throw log.ambiguousEntityManagerFactoryInJakartaBatch();
        }
        return (EntityManagerFactory)this.entityManagerFactoryInstance.get();
    }

    public EntityManagerFactory get(String reference) {
        return this.get(CDI_NAMESPACE_NAME, reference);
    }

    public EntityManagerFactory get(String namespace, String reference) {
        EntityManagerFactory factory;
        switch (namespace) {
            case "cdi": {
                Instance instance = this.entityManagerFactoryInstance.select(new Annotation[]{new NamedQualifier(reference)});
                if (instance.isUnsatisfied()) {
                    throw log.noAvailableEntityManagerFactoryInCDI(reference);
                }
                factory = (EntityManagerFactory)instance.get();
                break;
            }
            default: {
                throw log.unknownEntityManagerFactoryNamespace(namespace);
            }
        }
        return factory;
    }

    private static <T> T getVetoedBeanReference(BeanManager beanManager, Class<T> vetoedType) {
        AnnotatedType annotatedType = beanManager.createAnnotatedType(vetoedType);
        BeanAttributes beanAttributes = beanManager.createBeanAttributes(annotatedType);
        InjectionTargetFactory injectionTargetFactory = beanManager.getInjectionTargetFactory(annotatedType);
        Bean bean = beanManager.createBean(beanAttributes, vetoedType, injectionTargetFactory);
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        return vetoedType.cast(beanManager.getReference(bean, vetoedType, creationalContext));
    }

    @Vetoed
    private static class PersistenceUnitAccessor {
        @PersistenceUnit
        private EntityManagerFactory entityManagerFactory;

        private PersistenceUnitAccessor() {
        }
    }

    private static class NamedQualifier
    extends AnnotationLiteral<Named>
    implements Named {
        private final String name;

        public NamedQualifier(String name) {
            this.name = name;
        }

        public String value() {
            return this.name;
        }
    }
}

