/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session;

import jakarta.persistence.EntityManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.hibernate.Session;
import org.hibernate.search.engine.search.query.dsl.SearchQuerySelectStep;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.schema.management.SearchSchemaManager;
import org.hibernate.search.mapper.orm.scope.SearchScope;
import org.hibernate.search.mapper.orm.search.loading.dsl.SearchLoadingOptionsStep;
import org.hibernate.search.mapper.orm.work.SearchIndexingPlan;
import org.hibernate.search.mapper.orm.work.SearchWorkspace;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.work.SearchIndexingPlanFilter;
import org.hibernate.search.util.common.annotation.Incubating;

public interface SearchSession {
    default public <T> SearchQuerySelectStep<?, EntityReference, T, SearchLoadingOptionsStep, ?, ?> search(Class<T> type) {
        return this.search(Collections.singleton(type));
    }

    public <T> SearchQuerySelectStep<?, EntityReference, T, SearchLoadingOptionsStep, ?, ?> search(Collection<? extends Class<? extends T>> var1);

    public <T> SearchQuerySelectStep<?, EntityReference, T, SearchLoadingOptionsStep, ?, ?> search(SearchScope<T> var1);

    default public SearchSchemaManager schemaManager() {
        return this.schemaManager(Collections.singleton(Object.class));
    }

    default public SearchSchemaManager schemaManager(Class<?> ... types) {
        return this.schemaManager(Arrays.asList(types));
    }

    public SearchSchemaManager schemaManager(Collection<? extends Class<?>> var1);

    default public SearchWorkspace workspace() {
        return this.workspace(Collections.singleton(Object.class));
    }

    default public SearchWorkspace workspace(Class<?> ... types) {
        return this.workspace(Arrays.asList(types));
    }

    public SearchWorkspace workspace(Collection<? extends Class<?>> var1);

    default public MassIndexer massIndexer() {
        return this.massIndexer(Object.class);
    }

    default public MassIndexer massIndexer(Class<?> ... types) {
        return this.massIndexer(Arrays.asList(types));
    }

    public MassIndexer massIndexer(Collection<? extends Class<?>> var1);

    default public <T> SearchScope<T> scope(Class<T> type) {
        return this.scope(Collections.singleton(type));
    }

    public <T> SearchScope<T> scope(Collection<? extends Class<? extends T>> var1);

    default public <T> SearchScope<T> scope(Class<T> expectedSuperType, String entityName) {
        return this.scope(expectedSuperType, Collections.singleton(entityName));
    }

    public <T> SearchScope<T> scope(Class<T> var1, Collection<String> var2);

    public SearchIndexingPlan indexingPlan();

    public EntityManager toEntityManager();

    public Session toOrmSession();

    @Deprecated
    public void automaticIndexingSynchronizationStrategy(AutomaticIndexingSynchronizationStrategy var1);

    public void indexingPlanSynchronizationStrategy(IndexingPlanSynchronizationStrategy var1);

    @Incubating
    public void indexingPlanFilter(SearchIndexingPlanFilter var1);
}

