/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.cluster.impl;

import java.util.List;
import java.util.UUID;
import org.hibernate.Session;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.Agent;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentRepository;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentRepositoryProvider;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.OutboxPollingAgentAdditionalJaxbMappingProducer;

public class DefaultAgentRepository
implements AgentRepository {
    private final Session session;

    private DefaultAgentRepository(Session session) {
        this.session = session;
    }

    @Override
    public Agent find(UUID id) {
        return (Agent)this.session.find(Agent.class, (Object)id);
    }

    @Override
    public List<Agent> findAllOrderById() {
        return this.session.createQuery("select a from " + OutboxPollingAgentAdditionalJaxbMappingProducer.ENTITY_NAME + " a order by id", Agent.class).list();
    }

    @Override
    public void create(Agent agent) {
        this.session.persist((Object)agent);
    }

    @Override
    public void delete(List<Agent> agents) {
        for (Agent agent : agents) {
            this.session.remove((Object)agent);
        }
    }

    public static final class Provider
    implements AgentRepositoryProvider {
        @Override
        public AgentRepository create(Session session) {
            return new DefaultAgentRepository(session);
        }
    }
}

