/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.event.impl;

import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PessimisticLockException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEvent;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxPollingOutboxEventAdditionalJaxbMappingProducer;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.spi.ToStringTreeAppendable;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;

final class OutboxEventLoader
implements ToStringTreeAppendable {
    private static final String LOAD_QUERY_STRING = "select e from " + OutboxPollingOutboxEventAdditionalJaxbMappingProducer.ENTITY_NAME + " e where e.id in (:ids)";
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LockOptions lockOptions;

    OutboxEventLoader(Dialect dialect) {
        this.lockOptions = dialect.supportsSkipLocked() ? new LockOptions(LockMode.UPGRADE_SKIPLOCKED) : new LockOptions(LockMode.PESSIMISTIC_WRITE);
    }

    public String toString() {
        return this.toStringTree();
    }

    public void appendTo(ToStringTreeAppender appender) {
        appender.startObject("lockOptions").attribute("lockMode", (Object)this.lockOptions.getLockMode()).attribute("timeout", (Object)this.lockOptions.getTimeOut()).endObject();
    }

    List<OutboxEvent> loadLocking(Session session, Set<UUID> ids, String processorName) {
        try {
            Query query = session.createQuery(LOAD_QUERY_STRING, OutboxEvent.class);
            query.setParameter("ids", ids);
            query.setLockOptions(this.lockOptions);
            return query.getResultList();
        }
        catch (OptimisticLockException | PessimisticLockException lockException) {
            log.outboxEventProcessorUnableToLock(processorName, (PersistenceException)lockException);
            return Collections.emptyList();
        }
    }
}

