/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.cluster.impl;

import jakarta.persistence.Transient;
import java.time.Instant;
import java.util.UUID;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentReference;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentState;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentType;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.ShardAssignmentDescriptor;

public class Agent {
    private UUID id;
    private AgentType type;
    private String name;
    private Instant expiration;
    private AgentState state;
    private Integer totalShardCount;
    private Integer assignedShardIndex;
    private byte[] payload;
    private String tenantId;

    protected Agent() {
    }

    public Agent(AgentType type, String name, Instant expiration, AgentState state, ShardAssignmentDescriptor shardAssignment) {
        this.type = type;
        this.name = name;
        this.expiration = expiration;
        this.state = state;
        this.totalShardCount = shardAssignment == null ? null : Integer.valueOf(shardAssignment.totalShardCount);
        this.assignedShardIndex = shardAssignment == null ? null : Integer.valueOf(shardAssignment.assignedShardIndex);
    }

    public String toString() {
        return "Agent{id=" + String.valueOf(this.id) + ", name='" + this.name + "', expiration=" + String.valueOf(this.expiration) + ", type=" + String.valueOf((Object)this.type) + ", currentState=" + String.valueOf((Object)this.state) + ", totalShardCount=" + this.totalShardCount + ", assignedShardIndex=" + this.assignedShardIndex + ", tenantId=" + this.tenantId + "}";
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public AgentType getType() {
        return this.type;
    }

    public void setType(AgentType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Instant expiration) {
        this.expiration = expiration;
    }

    public AgentState getState() {
        return this.state;
    }

    public void setState(AgentState state) {
        this.state = state;
    }

    public Integer getTotalShardCount() {
        return this.totalShardCount;
    }

    public void setTotalShardCount(Integer totalShardCount) {
        this.totalShardCount = totalShardCount;
    }

    public Integer getAssignedShardIndex() {
        return this.assignedShardIndex;
    }

    public void setAssignedShardIndex(Integer assignedShardIndex) {
        this.assignedShardIndex = assignedShardIndex;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Transient
    public AgentReference getReference() {
        return AgentReference.of(this.id, this.name);
    }

    @Transient
    public ShardAssignmentDescriptor getShardAssignment() {
        return this.totalShardCount == null || this.assignedShardIndex == null ? null : new ShardAssignmentDescriptor(this.totalShardCount, this.assignedShardIndex);
    }
}

