/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.cluster.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Optional;
import org.hibernate.boot.jaxb.mapping.JaxbEntityMappings;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.mapper.orm.bootstrap.spi.HibernateSearchOrmMappingProducer;
import org.hibernate.search.mapper.orm.outboxpolling.cfg.HibernateOrmMapperOutboxPollingSettings;
import org.hibernate.search.mapper.orm.outboxpolling.cfg.UuidGenerationStrategy;
import org.hibernate.search.mapper.orm.outboxpolling.cfg.impl.UuidDataTypeUtils;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.Agent;
import org.hibernate.search.mapper.orm.outboxpolling.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.Log;
import org.hibernate.search.mapper.orm.outboxpolling.mapping.impl.AdditionalMappingBuilder;
import org.hibernate.search.mapper.orm.outboxpolling.mapping.impl.JaxbMappingHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class OutboxPollingAgentAdditionalJaxbMappingProducer
implements HibernateSearchOrmMappingProducer {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final String CLASS_NAME;
    public static final String ENTITY_NAME;
    public static final String ENTITY_DEFINITION;
    private static final OptionalConfigurationProperty<String> AGENT_ENTITY_MAPPING;
    private static final OptionalConfigurationProperty<String> ENTITY_MAPPING_AGENT_SCHEMA;
    private static final OptionalConfigurationProperty<String> ENTITY_MAPPING_AGENT_CATALOG;
    private static final OptionalConfigurationProperty<String> ENTITY_MAPPING_AGENT_TABLE;
    private static final OptionalConfigurationProperty<UuidGenerationStrategy> ENTITY_MAPPING_AGENT_UUID_GEN_STRATEGY;
    private static final OptionalConfigurationProperty<String> ENTITY_MAPPING_AGENT_UUID_TYPE;

    public Map<Class<?>, JaxbEntityMappings> produceMappings(ConfigurationPropertySource propertySource, MetadataBuildingContext buildingContext) {
        JaxbEntityMappings mappings;
        Optional mapping = (Optional)AGENT_ENTITY_MAPPING.get(propertySource);
        Optional schema = (Optional)ENTITY_MAPPING_AGENT_SCHEMA.get(propertySource);
        Optional catalog = (Optional)ENTITY_MAPPING_AGENT_CATALOG.get(propertySource);
        Optional table = (Optional)ENTITY_MAPPING_AGENT_TABLE.get(propertySource);
        Optional uuidStrategy = (Optional)ENTITY_MAPPING_AGENT_UUID_GEN_STRATEGY.get(propertySource);
        Optional uuidType = ENTITY_MAPPING_AGENT_UUID_TYPE.getAndMap(propertySource, value -> UuidDataTypeUtils.uuidType(value, propertySource, ENTITY_MAPPING_AGENT_UUID_TYPE));
        if (mapping.isPresent() && (schema.isPresent() || catalog.isPresent() || table.isPresent() || uuidStrategy.isPresent() || uuidType.isPresent())) {
            throw log.agentConfigurationPropertyConflict(AGENT_ENTITY_MAPPING.resolveOrRaw(propertySource), new String[]{ENTITY_MAPPING_AGENT_SCHEMA.resolveOrRaw(propertySource), ENTITY_MAPPING_AGENT_CATALOG.resolveOrRaw(propertySource), ENTITY_MAPPING_AGENT_TABLE.resolveOrRaw(propertySource), ENTITY_MAPPING_AGENT_UUID_GEN_STRATEGY.resolveOrRaw(propertySource), ENTITY_MAPPING_AGENT_UUID_TYPE.resolveOrRaw(propertySource)});
        }
        if (mapping.isPresent()) {
            mappings = JaxbMappingHelper.unmarshall((String)mapping.get());
        } else {
            Integer resolvedUuidType = uuidType.orElse(null);
            String resolvedUuidStrategy = uuidStrategy.orElse(HibernateOrmMapperOutboxPollingSettings.Defaults.COORDINATION_ENTITY_MAPPING_AGENT_UUID_GEN_STRATEGY).strategy();
            mappings = OutboxPollingAgentAdditionalJaxbMappingProducer.createMappings(schema.orElse(""), catalog.orElse(""), table.orElse("HSEARCH_AGENT"), resolvedUuidType, resolvedUuidStrategy, HibernateOrmUtils.isDiscriminatorMultiTenancyEnabled(buildingContext));
        }
        log.agentGeneratedEntityMapping(mappings);
        return Map.of(Agent.class, mappings);
    }

    private static JaxbEntityMappings createMappings(String schema, String catalog, String table, Integer resolvedUuidType, String resolvedUuidStrategy, boolean tenantIdRequired) {
        AdditionalMappingBuilder builder = new AdditionalMappingBuilder(Agent.class, ENTITY_NAME).id(resolvedUuidType, resolvedUuidStrategy).table(schema, catalog, table).enumAttribute("type", null, false).attribute("name", null, false).attribute("expiration", null, false).enumAttribute("state", null, false).attribute("totalShardCount", null, true).attribute("assignedShardIndex", null, true).attribute("payload", Integer.MAX_VALUE, true);
        if (tenantIdRequired) {
            builder.tenantId("tenantId");
        }
        return builder.build();
    }

    static {
        ENTITY_NAME = CLASS_NAME = Agent.class.getName();
        ENTITY_DEFINITION = JaxbMappingHelper.marshall(OutboxPollingAgentAdditionalJaxbMappingProducer.createMappings("", "", "HSEARCH_AGENT", 1, HibernateOrmMapperOutboxPollingSettings.Defaults.COORDINATION_ENTITY_MAPPING_AGENT_UUID_GEN_STRATEGY.strategy(), false));
        AGENT_ENTITY_MAPPING = ConfigurationProperty.forKey((String)"agent.entity.mapping").asString().build();
        ENTITY_MAPPING_AGENT_SCHEMA = ConfigurationProperty.forKey((String)"entity.mapping.agent.schema").asString().build();
        ENTITY_MAPPING_AGENT_CATALOG = ConfigurationProperty.forKey((String)"entity.mapping.agent.catalog").asString().build();
        ENTITY_MAPPING_AGENT_TABLE = ConfigurationProperty.forKey((String)"entity.mapping.agent.table").asString().build();
        ENTITY_MAPPING_AGENT_UUID_GEN_STRATEGY = ConfigurationProperty.forKey((String)"entity.mapping.agent.uuid_gen_strategy").as(UuidGenerationStrategy.class, UuidGenerationStrategy::of).build();
        ENTITY_MAPPING_AGENT_UUID_TYPE = ConfigurationProperty.forKey((String)"entity.mapping.outboxevent.uuid_type").asString().build();
    }
}

