/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.event.impl;

import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.search.mapper.orm.common.spi.SessionHelper;
import org.hibernate.search.mapper.orm.common.spi.TransactionHelper;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentRepository;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentRepositoryProvider;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public class AgentClusterLinkContext {
    private final TransactionHelper transactionHelper;
    private final SessionHelper sessionHelper;
    private final AgentRepositoryProvider agentRepositoryProvider;
    private SessionImplementor session;
    private AgentRepository agentRepository;

    public AgentClusterLinkContext(TransactionHelper transactionHelper, SessionHelper sessionHelper, AgentRepositoryProvider agentRepositoryProvider) {
        this.transactionHelper = transactionHelper;
        this.sessionHelper = sessionHelper;
        this.agentRepositoryProvider = agentRepositoryProvider;
    }

    void begin() {
        this.session = this.sessionHelper.openSession();
        this.transactionHelper.begin((SharedSessionContractImplementor)this.session);
        this.agentRepository = this.agentRepositoryProvider.create((Session)this.session);
    }

    public AgentRepository agentRepository() {
        return this.agentRepository;
    }

    public void commitAndBeginNewTransaction() {
        this.commit();
        this.begin();
    }

    void commit() {
        try (Closer closer = new Closer();){
            closer.push(arg_0 -> ((TransactionHelper)this.transactionHelper).commit(arg_0), (Object)this.session);
            closer.push(SharedSessionContract::close, (Object)this.session);
            this.session = null;
            this.agentRepository = null;
        }
    }

    void rollbackLatestTransactionSafely(Throwable t) {
        ((SuppressingCloser)new SuppressingCloser(t).push(s -> this.transactionHelper.rollbackSafely((SharedSessionContractImplementor)s, t), (Object)this.session)).push(SharedSessionContract::close, (Object)this.session);
    }
}

