/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.event.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.reporting.EntityIndexingFailureContext;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEvent;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEventLoader;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEventProcessingPlan;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.OutboxPollingEventsLog;
import org.hibernate.search.util.common.SearchException;

public class OutboxEventUpdater {
    private static final int MAX_RETRIES = 3;
    private final FailureHandler failureHandler;
    private final OutboxEventLoader loader;
    private final OutboxEventProcessingPlan processingPlan;
    private final SessionImplementor session;
    private final String processorName;
    private final int retryAfter;
    private final Set<UUID> eventsIds;
    private final Set<UUID> failedEventIds;

    public OutboxEventUpdater(FailureHandler failureHandler, OutboxEventLoader loader, OutboxEventProcessingPlan processingPlan, SessionImplementor session, String processorName, int retryAfter) {
        this.failureHandler = failureHandler;
        this.loader = loader;
        this.processingPlan = processingPlan;
        this.session = session;
        this.processorName = processorName;
        this.retryAfter = retryAfter;
        this.eventsIds = processingPlan.getEvents().stream().map(OutboxEvent::getId).collect(Collectors.toSet());
        this.failedEventIds = processingPlan.getFailedEvents().stream().map(OutboxEvent::getId).collect(Collectors.toSet());
    }

    public boolean thereAreStillEventsToProcess() {
        return !this.eventsIds.isEmpty();
    }

    public Set<UUID> eventsToProcess() {
        return Collections.unmodifiableSet(this.eventsIds);
    }

    public void process() {
        List<OutboxEvent> lockedEvents = this.loader.loadLocking((Session)this.session, this.eventsIds, this.processorName);
        ArrayList<OutboxEvent> eventToDelete = new ArrayList<OutboxEvent>(lockedEvents);
        for (OutboxEvent event : lockedEvents) {
            UUID id = event.getId();
            this.eventsIds.remove(id);
            if (!this.failedEventIds.contains(id)) continue;
            eventToDelete.remove(event);
            int attempts = event.getRetries() + 1;
            if (attempts >= 3) {
                this.notifyMaxRetriesReached(event);
                event.setStatus(OutboxEvent.Status.ABORTED);
                continue;
            }
            event.setRetries(attempts);
            Instant processAfter = this.retryAfter > 0 ? Instant.now().plusSeconds(this.retryAfter) : Instant.now();
            event.setProcessAfter(processAfter);
            OutboxPollingEventsLog.INSTANCE.backgroundIndexingRetry(event.getId(), event.getEntityName(), event.getEntityId(), attempts, processAfter);
        }
        for (OutboxEvent event : eventToDelete) {
            this.session.remove((Object)event);
        }
    }

    private void notifyMaxRetriesReached(OutboxEvent failedEvent) {
        EntityIndexingFailureContext.Builder builder = EntityIndexingFailureContext.builder();
        SearchException exception = OutboxPollingEventsLog.INSTANCE.maxRetryExhausted(3);
        builder.throwable((Throwable)exception);
        builder.failingOperation((Object)"Processing an outbox event.");
        builder.failingEntityReference(this.processingPlan.entityReference(failedEvent.getEntityName(), failedEvent.getEntityId(), (Throwable)exception));
        this.failureHandler.handle(builder.build());
    }
}

