/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.mapper.orm.bootstrap.spi.HibernateSearchOrmMappingProducer;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationConfigurationContext;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationStrategy;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationStrategyPreStopContext;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationStrategyStartContext;
import org.hibernate.search.mapper.orm.outboxpolling.cfg.HibernateOrmMapperOutboxPollingSettings;
import org.hibernate.search.mapper.orm.outboxpolling.cfg.OutboxEventProcessingOrder;
import org.hibernate.search.mapper.orm.outboxpolling.cfg.UuidGenerationStrategy;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentRepositoryProvider;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.DefaultAgentRepository;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.OutboxPollingAgentAdditionalMappingProducer;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.ShardAssignmentDescriptor;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.DefaultOutboxEventFinder;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEventFinderProvider;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEventOrder;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxPollingEventProcessor;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxPollingMassIndexerAgent;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxPollingOutboxEventAdditionalMappingProducer;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxPollingOutboxEventSendingPlan;
import org.hibernate.search.mapper.orm.outboxpolling.impl.OutboxPollingInternalConfigurer;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.ConfigurationLog;
import org.hibernate.search.mapper.orm.outboxpolling.mapping.impl.OutboxPollingSearchMappingImpl;
import org.hibernate.search.mapper.orm.tenancy.spi.TenancyConfiguration;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexerAgent;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexerAgentCreateContext;
import org.hibernate.search.util.common.impl.Closer;

public class OutboxPollingCoordinationStrategy
implements CoordinationStrategy {
    private static final ConfigurationProperty<Boolean> EVENT_PROCESSOR_ENABLED = ConfigurationProperty.forKey((String)"event_processor.enabled").asBoolean().withDefault((Object)true).build();
    private static final OptionalConfigurationProperty<Integer> EVENT_PROCESSOR_SHARDS_TOTAL_COUNT = ConfigurationProperty.forKey((String)"event_processor.shards.total_count").asIntegerStrictlyPositive().build();
    private static final OptionalConfigurationProperty<List<Integer>> EVENT_PROCESSOR_SHARDS_ASSIGNED = ConfigurationProperty.forKey((String)"event_processor.shards.assigned").asIntegerPositiveOrZero().multivalued().build();
    private static final ConfigurationProperty<OutboxEventProcessingOrder> EVENT_PROCESSOR_ORDER = ConfigurationProperty.forKey((String)"event_processor.order").as(OutboxEventProcessingOrder.class, OutboxEventProcessingOrder::of).withDefault((Object)HibernateOrmMapperOutboxPollingSettings.Defaults.COORDINATION_EVENT_PROCESSOR_ORDER).build();
    private static final ConfigurationProperty<BeanReference<? extends OutboxPollingInternalConfigurer>> INTERNAL_CONFIGURER = ConfigurationProperty.forKey((String)"internal.configurer").asBeanReference(OutboxPollingInternalConfigurer.class).withDefault((Object)BeanReference.ofInstance((Object)OutboxPollingInternalConfigurer.DEFAULT)).build();
    private OutboxEventFinderProvider finderProvider;
    private AgentRepositoryProvider agentRepositoryProvider;
    private TenancyConfiguration tenancyConfiguration;
    private final Map<String, TenantDelegate> tenantDelegates = new LinkedHashMap<String, TenantDelegate>();
    private OutboxPollingSearchMappingImpl outboxPollingSearchMapping;

    public void configure(CoordinationConfigurationContext context) {
        context.mappingProducer((HibernateSearchOrmMappingProducer)new OutboxPollingOutboxEventAdditionalMappingProducer());
        context.mappingProducer((HibernateSearchOrmMappingProducer)new OutboxPollingAgentAdditionalMappingProducer());
        context.sendIndexingEventsTo(ctx -> new OutboxPollingOutboxEventSendingPlan(ctx.entityReferenceFactory(), ctx.session()), true);
    }

    public CompletableFuture<?> start(CoordinationStrategyStartContext context) {
        ConfigurationPropertySource configurationSource = context.configurationPropertySource();
        OutboxEventOrder processingOrder = OutboxEventOrder.of((OutboxEventProcessingOrder)((Object)EVENT_PROCESSOR_ORDER.get(configurationSource)), ((Optional)OutboxPollingOutboxEventAdditionalMappingProducer.ENTITY_MAPPING_OUTBOXEVENT_UUID_GEN_STRATEGY.get(configurationSource)).orElse(UuidGenerationStrategy.AUTO), context.mapping().sessionFactory().getJdbcServices().getDialect());
        try (BeanHolder internalConfigurerHolder = (BeanHolder)INTERNAL_CONFIGURER.getAndTransform(configurationSource, arg_0 -> ((BeanResolver)context.beanResolver()).resolve(arg_0));){
            OutboxPollingInternalConfigurer internalConfigurer = (OutboxPollingInternalConfigurer)internalConfigurerHolder.get();
            this.agentRepositoryProvider = internalConfigurer.wrapAgentRepository(new DefaultAgentRepository.Provider());
            this.finderProvider = internalConfigurer.wrapEventFinder(new DefaultOutboxEventFinder.Provider(processingOrder));
        }
        this.tenancyConfiguration = context.tenancyConfiguration();
        Set tenantIds = this.tenancyConfiguration.tenantIdsOrFail();
        if (tenantIds.isEmpty()) {
            TenantDelegate tenantDelegate = new TenantDelegate(null);
            this.tenantDelegates.put(null, tenantDelegate);
            tenantDelegate.start(context, configurationSource);
        } else {
            for (String tenantId : tenantIds) {
                TenantDelegate tenantDelegate = new TenantDelegate(tenantId);
                this.tenantDelegates.put(tenantId, tenantDelegate);
                ConfigurationPropertySource tenantConfigurationSource = configurationSource.withMask("tenants").withMask(tenantId).withFallback(configurationSource);
                tenantDelegate.start(context, tenantConfigurationSource);
            }
        }
        this.outboxPollingSearchMapping = new OutboxPollingSearchMappingImpl(context, this.tenancyConfiguration);
        return CompletableFuture.completedFuture(null);
    }

    public PojoMassIndexerAgent createMassIndexerAgent(PojoMassIndexerAgentCreateContext context) {
        return this.tenantDelegate((String)context.tenantIdentifier()).massIndexerAgentFactory.create(this.agentRepositoryProvider);
    }

    private TenantDelegate tenantDelegate(String tenantId) {
        TenantDelegate tenantDelegate = this.tenantDelegates.get(tenantId);
        if (tenantDelegate == null) {
            throw this.tenancyConfiguration.invalidTenantId(tenantId);
        }
        return tenantDelegate;
    }

    public CompletableFuture<?> completion() {
        ArrayList futures = new ArrayList();
        for (TenantDelegate tenantDelegate : this.tenantDelegates.values()) {
            if (tenantDelegate.eventProcessors == null) continue;
            for (OutboxPollingEventProcessor eventProcessor : tenantDelegate.eventProcessors) {
                futures.add(eventProcessor.completion());
            }
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public CompletableFuture<?> preStop(CoordinationStrategyPreStopContext context) {
        ArrayList futures = new ArrayList();
        for (TenantDelegate tenantDelegate : this.tenantDelegates.values()) {
            if (tenantDelegate.eventProcessors == null) continue;
            for (OutboxPollingEventProcessor eventProcessor : tenantDelegate.eventProcessors) {
                futures.add(eventProcessor.preStop());
            }
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public void stop() {
        try (Closer closer = new Closer();){
            for (TenantDelegate tenantDelegate : this.tenantDelegates.values()) {
                closer.pushAll(OutboxPollingEventProcessor::stop, tenantDelegate.eventProcessors);
                closer.push(ExecutorService::shutdownNow, (Object)tenantDelegate.eventProcessorExecutor);
            }
        }
    }

    public OutboxPollingSearchMappingImpl outboxPollingSearchMapping() {
        return this.outboxPollingSearchMapping;
    }

    private class TenantDelegate {
        private final String tenantId;
        private ScheduledExecutorService eventProcessorExecutor;
        private List<OutboxPollingEventProcessor> eventProcessors;
        private OutboxPollingMassIndexerAgent.Factory massIndexerAgentFactory;

        private TenantDelegate(String tenantId) {
            this.tenantId = tenantId;
        }

        void start(CoordinationStrategyStartContext context, ConfigurationPropertySource configurationSource) {
            if (((Boolean)EVENT_PROCESSOR_ENABLED.get(configurationSource)).booleanValue()) {
                this.initializeEventProcessors(context, configurationSource);
            } else {
                ConfigurationLog.INSTANCE.eventProcessorDisabled(this.tenantId);
            }
            this.massIndexerAgentFactory = OutboxPollingMassIndexerAgent.factory(context.mapping(), context.clock(), this.tenantId, configurationSource);
        }

        private void initializeEventProcessors(CoordinationStrategyStartContext context, ConfigurationPropertySource configurationSource) {
            List shardAssignmentOrNulls;
            boolean shardsStatic;
            OutboxPollingEventProcessor.Factory factory = OutboxPollingEventProcessor.factory(context.mapping(), context.clock(), this.tenantId, configurationSource);
            boolean bl = shardsStatic = ((Optional)EVENT_PROCESSOR_SHARDS_TOTAL_COUNT.get(configurationSource)).isPresent() || ((Optional)EVENT_PROCESSOR_SHARDS_ASSIGNED.get(configurationSource)).isPresent();
            if (shardsStatic) {
                int totalShardCount = (Integer)EVENT_PROCESSOR_SHARDS_TOTAL_COUNT.getAndMapOrThrow(configurationSource, this::checkTotalShardCount, () -> ConfigurationLog.INSTANCE.missingPropertyForStaticSharding(EVENT_PROCESSOR_SHARDS_ASSIGNED.resolveOrRaw(configurationSource)));
                shardAssignmentOrNulls = (List)EVENT_PROCESSOR_SHARDS_ASSIGNED.getAndMapOrThrow(configurationSource, shardIndices -> this.toStaticShardAssignments(configurationSource, totalShardCount, (List<Integer>)shardIndices), () -> ConfigurationLog.INSTANCE.missingPropertyForStaticSharding(EVENT_PROCESSOR_SHARDS_TOTAL_COUNT.resolveOrRaw(configurationSource)));
            } else {
                shardAssignmentOrNulls = Collections.singletonList(null);
            }
            this.eventProcessorExecutor = context.threadPoolProvider().newScheduledExecutor(shardAssignmentOrNulls.size(), OutboxPollingEventProcessor.namePrefix(this.tenantId));
            this.eventProcessors = new ArrayList<OutboxPollingEventProcessor>();
            for (ShardAssignmentDescriptor shardAssignmentOrNull : shardAssignmentOrNulls) {
                this.eventProcessors.add(factory.create(this.eventProcessorExecutor, OutboxPollingCoordinationStrategy.this.finderProvider, OutboxPollingCoordinationStrategy.this.agentRepositoryProvider, shardAssignmentOrNull));
            }
            for (OutboxPollingEventProcessor eventProcessor : this.eventProcessors) {
                eventProcessor.start();
            }
        }

        private Integer checkTotalShardCount(Integer totalShardCount) {
            if (totalShardCount <= 0) {
                throw ConfigurationLog.INSTANCE.invalidTotalShardCount();
            }
            return totalShardCount;
        }

        private List<ShardAssignmentDescriptor> toStaticShardAssignments(ConfigurationPropertySource configurationPropertySource, int totalShardCount, List<Integer> shardIndices) {
            HashSet<Integer> uniqueShardIndices = new HashSet<Integer>(shardIndices);
            for (Integer shardIndex : uniqueShardIndices) {
                if (0 <= shardIndex && shardIndex < totalShardCount) continue;
                throw ConfigurationLog.INSTANCE.invalidShardIndex(totalShardCount, EVENT_PROCESSOR_SHARDS_TOTAL_COUNT.resolveOrRaw(configurationPropertySource));
            }
            ArrayList<ShardAssignmentDescriptor> shardAssignment = new ArrayList<ShardAssignmentDescriptor>();
            for (Integer shardIndex : uniqueShardIndices) {
                shardAssignment.add(new ShardAssignmentDescriptor(totalShardCount, shardIndex));
            }
            return shardAssignment;
        }
    }
}

