/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.mapping.impl;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.ConfigurationLog;

public class JaxbMappingHelper {
    private JaxbMappingHelper() {
    }

    public static String marshall(JaxbEntityMappingsImpl mappings) {
        String string;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{JaxbEntityMappingsImpl.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)mappings, (OutputStream)out);
            string = out.toString(StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JAXBException | IOException e) {
                throw ConfigurationLog.INSTANCE.unableToProcessEntityMappings(e.getMessage(), (Exception)e);
            }
        }
        out.close();
        return string;
    }

    public static JaxbEntityMappingsImpl unmarshall(String mappings) {
        JaxbEntityMappingsImpl jaxbEntityMappingsImpl;
        ByteArrayInputStream in = new ByteArrayInputStream(mappings.getBytes(StandardCharsets.UTF_8));
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{JaxbEntityMappingsImpl.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            jaxbEntityMappingsImpl = (JaxbEntityMappingsImpl)unmarshaller.unmarshal((InputStream)in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JAXBException | IOException e) {
                throw ConfigurationLog.INSTANCE.unableToProcessEntityMappings(e.getMessage(), (Exception)e);
            }
        }
        in.close();
        return jaxbEntityMappingsImpl;
    }
}

