/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.cfg.impl;

import java.util.Locale;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.ConfigurationLog;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.DeprecationLog;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;

public final class UuidDataTypeUtils {
    private static final String DEFAULT = "default";
    @Deprecated(since="7.0")
    private static final String UUID_BINARY = "uuid-binary";
    @Deprecated(since="7.0")
    private static final String UUID_CHAR = "uuid-char";

    private UuidDataTypeUtils() {
    }

    public static Integer uuidType(String value, ConfigurationPropertySource source, OptionalConfigurationProperty<String> property) {
        if (DEFAULT.equalsIgnoreCase(value)) {
            return null;
        }
        String propertyName = property.resolveOrRaw(source);
        if (UUID_CHAR.equalsIgnoreCase(value)) {
            DeprecationLog.INSTANCE.usingDeprecatedPropertyValue(propertyName, value, "CHAR");
            return 1;
        }
        if (UUID_BINARY.equalsIgnoreCase(value)) {
            DeprecationLog.INSTANCE.usingDeprecatedPropertyValue(propertyName, value, "BINARY");
            return -2;
        }
        return TypeCodeConverter.convert(value);
    }

    private static class TypeCodeConverter {
        private TypeCodeConverter() {
        }

        public static int convert(String value) {
            String string = value.toUpperCase(Locale.ROOT);
            Integer typeCode = JdbcTypeNameMapper.getTypeCode((String)string);
            if (typeCode != null) {
                return typeCode;
            }
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException ex) {
                throw ConfigurationLog.INSTANCE.unableToParseJdbcTypeCode(value, ex.getMessage(), ex);
            }
        }
    }
}

